/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.section.AbstractSection;
import org.eclipse.wst.xsd.ui.internal.properties.section.XSDWorkbook;
import org.eclipse.wst.xsd.ui.internal.properties.section.XSDWorkbookPage;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDIdentityConstraintDefinition;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNotationDeclaration;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.XSDXPathDefinition;
import org.eclipse.xsd.impl.XSDFactoryImpl;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AnnotationSection
extends AbstractSection {
    DocumentationWorkbookPage documentationPage;
    AppInfoWorkbookPage appInfoPage;
    XSDWorkbook workbook;
    XSDFactory factory = new XSDFactoryImpl();

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        this.workbook = new XSDWorkbook(parent, 0x800400);
        this.documentationPage = new DocumentationWorkbookPage(this.workbook);
        this.appInfoPage = new AppInfoWorkbookPage(this.workbook);
        this.documentationPage.activate();
        this.appInfoPage.activate();
        this.workbook.setSelectedPage(this.documentationPage);
    }

    public void refresh() {
        if (this.doRefresh) {
            if (this.documentationPage.getDocumentationText().isFocusControl() || this.appInfoPage.getAppInfoText().isFocusControl()) {
                return;
            }
            if (this.isReadOnly) {
                this.documentationPage.setEnabled(false);
                this.appInfoPage.setEnabled(false);
            } else {
                this.documentationPage.setEnabled(true);
                this.appInfoPage.setEnabled(true);
            }
            this.setListenerEnabled(false);
            Object input = this.getInput();
            if (input != null) {
                XSDAnnotation xsdAnnotation = this.getInputXSDAnnotation(false);
                this.setInitialText(xsdAnnotation);
            }
            this.setListenerEnabled(true);
        }
    }

    public void doHandleEvent(Event event) {
        Object input = this.getInput();
        if (input != null) {
            XSDAnnotation xsdAnnotation = this.getInputXSDAnnotation(true);
            if (event.widget == this.documentationPage.getDocumentationText()) {
                this.documentationPage.doHandleEvent(xsdAnnotation);
            } else if (event.widget == this.appInfoPage.getAppInfoText()) {
                this.appInfoPage.doHandleEvent(xsdAnnotation);
            }
        }
    }

    protected XSDAnnotation getInputXSDAnnotation(boolean createIfNotExist) {
        XSDAnnotation xsdAnnotation = null;
        if (this.input instanceof XSDAttributeDeclaration) {
            XSDAttributeDeclaration xsdComp = (XSDAttributeDeclaration)this.input;
            xsdAnnotation = xsdComp.getAnnotation();
            if (createIfNotExist && xsdAnnotation == null) {
                xsdAnnotation = this.factory.createXSDAnnotation();
                xsdComp.setAnnotation(xsdAnnotation);
            }
        } else if (this.input instanceof XSDAttributeGroupDefinition) {
            XSDAttributeGroupDefinition xsdComp = (XSDAttributeGroupDefinition)this.input;
            xsdAnnotation = xsdComp.getAnnotation();
            if (createIfNotExist && xsdAnnotation == null) {
                xsdAnnotation = this.factory.createXSDAnnotation();
                xsdComp.setAnnotation(xsdAnnotation);
            }
        } else if (this.input instanceof XSDElementDeclaration) {
            XSDElementDeclaration xsdComp = (XSDElementDeclaration)this.input;
            xsdAnnotation = xsdComp.getAnnotation();
            if (createIfNotExist && xsdAnnotation == null) {
                xsdAnnotation = this.factory.createXSDAnnotation();
                xsdComp.setAnnotation(xsdAnnotation);
            }
        } else if (this.input instanceof XSDNotationDeclaration) {
            XSDNotationDeclaration xsdComp = (XSDNotationDeclaration)this.input;
            xsdAnnotation = xsdComp.getAnnotation();
            if (createIfNotExist && xsdAnnotation == null) {
                xsdAnnotation = this.factory.createXSDAnnotation();
                xsdComp.setAnnotation(xsdAnnotation);
            }
        } else if (this.input instanceof XSDXPathDefinition) {
            XSDXPathDefinition xsdComp = (XSDXPathDefinition)this.input;
            xsdAnnotation = xsdComp.getAnnotation();
            if (createIfNotExist && xsdAnnotation == null) {
                xsdAnnotation = this.factory.createXSDAnnotation();
                xsdComp.setAnnotation(xsdAnnotation);
            }
        } else if (this.input instanceof XSDModelGroup) {
            XSDModelGroup xsdComp = (XSDModelGroup)this.input;
            xsdAnnotation = xsdComp.getAnnotation();
            if (createIfNotExist && xsdAnnotation == null) {
                xsdAnnotation = this.factory.createXSDAnnotation();
                xsdComp.setAnnotation(xsdAnnotation);
            }
        } else if (this.input instanceof XSDModelGroupDefinition) {
            XSDModelGroupDefinition xsdComp = (XSDModelGroupDefinition)this.input;
            xsdAnnotation = xsdComp.getAnnotation();
            if (createIfNotExist && xsdAnnotation == null) {
                xsdAnnotation = this.factory.createXSDAnnotation();
                xsdComp.setAnnotation(xsdAnnotation);
            }
        } else if (this.input instanceof XSDIdentityConstraintDefinition) {
            XSDIdentityConstraintDefinition xsdComp = (XSDIdentityConstraintDefinition)this.input;
            xsdAnnotation = xsdComp.getAnnotation();
            if (createIfNotExist && xsdAnnotation == null) {
                xsdAnnotation = this.factory.createXSDAnnotation();
                xsdComp.setAnnotation(xsdAnnotation);
            }
        } else if (this.input instanceof XSDWildcard) {
            XSDWildcard xsdComp = (XSDWildcard)this.input;
            xsdAnnotation = xsdComp.getAnnotation();
            if (createIfNotExist && xsdAnnotation == null) {
                xsdAnnotation = this.factory.createXSDAnnotation();
                xsdComp.setAnnotation(xsdAnnotation);
            }
        } else {
            if (this.input instanceof XSDSchema) {
                XSDSchema xsdComp = (XSDSchema)this.input;
                EList list = xsdComp.getAnnotations();
                if (list.size() > 0) {
                    xsdAnnotation = (XSDAnnotation)list.get(0);
                } else if (createIfNotExist && xsdAnnotation == null) {
                    xsdAnnotation = this.factory.createXSDAnnotation();
                    if (xsdComp.getContents() != null) {
                        xsdComp.getContents().add(0, (Object)xsdAnnotation);
                    }
                }
                return xsdAnnotation;
            }
            if (this.input instanceof XSDFacet) {
                XSDFacet xsdComp = (XSDFacet)this.input;
                xsdAnnotation = xsdComp.getAnnotation();
                if (createIfNotExist && xsdAnnotation == null) {
                    xsdAnnotation = this.factory.createXSDAnnotation();
                    xsdComp.setAnnotation(xsdAnnotation);
                }
            } else if (this.input instanceof XSDTypeDefinition) {
                XSDTypeDefinition xsdComp = (XSDTypeDefinition)this.input;
                xsdAnnotation = xsdComp.getAnnotation();
                if (createIfNotExist && xsdAnnotation == null) {
                    xsdAnnotation = this.factory.createXSDAnnotation();
                    xsdComp.setAnnotation(xsdAnnotation);
                }
            } else if (this.input instanceof XSDInclude) {
                XSDInclude xsdComp = (XSDInclude)this.input;
                xsdAnnotation = xsdComp.getAnnotation();
                if (createIfNotExist && xsdAnnotation == null) {
                    xsdAnnotation = this.factory.createXSDAnnotation();
                    xsdComp.setAnnotation(xsdAnnotation);
                }
            } else if (this.input instanceof XSDImport) {
                XSDImport xsdComp = (XSDImport)this.input;
                xsdAnnotation = xsdComp.getAnnotation();
                if (createIfNotExist && xsdAnnotation == null) {
                    xsdAnnotation = this.factory.createXSDAnnotation();
                    xsdComp.setAnnotation(xsdAnnotation);
                }
            } else {
                if (this.input instanceof XSDRedefine) {
                    XSDRedefine xsdComp = (XSDRedefine)this.input;
                    EList list = xsdComp.getAnnotations();
                    if (list.size() > 0) {
                        xsdAnnotation = (XSDAnnotation)list.get(0);
                    } else if (createIfNotExist) {
                        // empty if block
                    }
                    return xsdAnnotation;
                }
                if (this.input instanceof XSDAnnotation) {
                    xsdAnnotation = (XSDAnnotation)this.input;
                }
            }
        }
        if (createIfNotExist) {
            this.formatAnnotation(xsdAnnotation);
        }
        return xsdAnnotation;
    }

    private void formatAnnotation(XSDAnnotation annotation) {
        Element element = annotation.getElement();
        XSDDOMHelper.formatChild(element);
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void dispose() {
        this.factory = null;
    }

    private void setInitialText(XSDAnnotation an) {
        if (this.documentationPage != null) {
            this.documentationPage.setText("");
        }
        if (this.appInfoPage != null) {
            this.appInfoPage.setText("");
        }
        if (an != null) {
            Element element = an.getElement();
            try {
                if (element.hasChildNodes()) {
                    Node node;
                    Element appInfoElement;
                    Node node2;
                    Element docElement = (Element)this.domHelper.getChildNode(element, "documentation");
                    if (docElement != null && (node2 = docElement.getFirstChild()) instanceof CharacterData) {
                        this.documentationPage.setText(((CharacterData)node2).getData());
                    }
                    if ((appInfoElement = (Element)this.domHelper.getChildNode(element, "appinfo")) != null && (node = appInfoElement.getFirstChild()) instanceof CharacterData) {
                        this.appInfoPage.setText(((CharacterData)node).getData());
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    class DocumentationWorkbookPage
    extends XSDWorkbookPage {
        Text documentationText;
        Composite page1;

        public DocumentationWorkbookPage(XSDWorkbook workbook) {
            super(workbook);
            this.getTabItem().setText(XSDEditorPlugin.getXSDString("_UI_LABEL_DOCUMENTATION"));
        }

        public void setText(String value) {
            this.documentationText.setText(value);
        }

        public void setEnabled(boolean state) {
            this.page1.setEnabled(state);
        }

        public String getText() {
            return this.documentationText.getText();
        }

        public Text getDocumentationText() {
            return this.documentationText;
        }

        public Control createControl(Composite parent) {
            this.page1 = AnnotationSection.this.getWidgetFactory().createFlatFormComposite(parent);
            this.documentationText = AnnotationSection.this.getWidgetFactory().createText(this.page1, "", 768);
            this.documentationText.addListener(24, (Listener)AnnotationSection.this);
            FormData data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment(0, 0);
            data.bottom = new FormAttachment(100, 0);
            this.documentationText.setLayoutData((Object)data);
            return this.page1;
        }

        public void doHandleEvent(XSDAnnotation xsdAnnotation) {
            if (xsdAnnotation != null) {
                Element element = xsdAnnotation.getElement();
                EList documentationList = xsdAnnotation.getUserInformation();
                Element documentationElement = null;
                if (documentationList.size() > 0) {
                    documentationElement = (Element)documentationList.get(0);
                }
                AnnotationSection.this.beginRecording(XSDEditorPlugin.getXSDString("_UI_DOCUMENTATION_COMMENT_CHANGE"), element);
                if (documentationElement == null) {
                    documentationElement = xsdAnnotation.createUserInformation(null);
                    element.appendChild(documentationElement);
                    XSDDOMHelper.formatChild(documentationElement);
                    xsdAnnotation.updateElement();
                    xsdAnnotation.setElement(element);
                }
                String newValue = this.documentationText.getText();
                if (documentationElement != null) {
                    try {
                        if (documentationElement.hasChildNodes()) {
                            Node node = documentationElement.getFirstChild();
                            if (node instanceof CharacterData) {
                                ((CharacterData)node).setData(newValue);
                            }
                        } else if (newValue.length() > 0) {
                            org.w3c.dom.Text childNode = documentationElement.getOwnerDocument().createTextNode(newValue);
                            documentationElement.appendChild(childNode);
                        }
                    }
                    catch (Exception exception) {}
                }
                AnnotationSection.this.endRecording(element);
            }
        }
    }

    class AppInfoWorkbookPage
    extends XSDWorkbookPage {
        Text appInfoText;
        Composite page2;

        public AppInfoWorkbookPage(XSDWorkbook workbook) {
            super(workbook);
            this.getTabItem().setText(XSDEditorPlugin.getXSDString("_UI_LABEL_APP_INFO"));
        }

        public void setText(String value) {
            this.appInfoText.setText(value);
        }

        public String getText() {
            return this.appInfoText.getText();
        }

        public Text getAppInfoText() {
            return this.appInfoText;
        }

        public void setEnabled(boolean state) {
            this.page2.setEnabled(state);
        }

        public Control createControl(Composite parent) {
            this.page2 = AnnotationSection.this.getWidgetFactory().createFlatFormComposite(parent);
            this.appInfoText = AnnotationSection.this.getWidgetFactory().createText(this.page2, "", 768);
            this.appInfoText.addListener(24, (Listener)AnnotationSection.this);
            FormData data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment(0, 0);
            data.bottom = new FormAttachment(100, 0);
            this.appInfoText.setLayoutData((Object)data);
            return this.page2;
        }

        public void doHandleEvent(XSDAnnotation xsdAnnotation) {
            if (xsdAnnotation != null) {
                Element element = xsdAnnotation.getElement();
                EList appInfoList = xsdAnnotation.getApplicationInformation();
                Element appInfoElement = null;
                if (appInfoList.size() > 0) {
                    appInfoElement = (Element)appInfoList.get(0);
                }
                AnnotationSection.this.beginRecording(XSDEditorPlugin.getXSDString("_UI_COMMENT_CHANGE"), element);
                if (appInfoElement == null) {
                    appInfoElement = xsdAnnotation.createApplicationInformation(null);
                    element.appendChild(appInfoElement);
                    XSDDOMHelper.formatChild(appInfoElement);
                }
                String newValue = this.appInfoText.getText();
                if (appInfoElement != null) {
                    try {
                        if (appInfoElement.hasChildNodes()) {
                            Node node = appInfoElement.getFirstChild();
                            if (node instanceof CharacterData) {
                                ((CharacterData)node).setData(newValue);
                            }
                        } else if (newValue.length() > 0) {
                            org.w3c.dom.Text childNode = appInfoElement.getOwnerDocument().createTextNode(newValue);
                            appInfoElement.appendChild(childNode);
                        }
                    }
                    catch (Exception exception) {}
                    AnnotationSection.this.endRecording(element);
                }
            }
        }
    }
}

