/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.BasePropertySource;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.wst.xsd.ui.internal.util.ViewUtility;
import org.eclipse.wst.xsd.ui.internal.widgets.TypeSection;
import org.eclipse.xsd.XSDSchema;

public class SimpleTypeUnionPropertySource
extends BasePropertySource
implements IPropertySource {
    public SimpleTypeUnionPropertySource() {
    }

    public SimpleTypeUnionPropertySource(Viewer viewer, XSDSchema xsdSchema) {
        super(viewer, xsdSchema);
    }

    public SimpleTypeUnionPropertySource(XSDSchema xsdSchema) {
        super(xsdSchema);
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<SimpleUnionMemberTypesPropertyDescriptor> list = new ArrayList<SimpleUnionMemberTypesPropertyDescriptor>();
        SimpleUnionMemberTypesPropertyDescriptor typeDescriptor = new SimpleUnionMemberTypesPropertyDescriptor("memberTypes", "memberTypes");
        typeDescriptor.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }
        });
        list.add(typeDescriptor);
        IPropertyDescriptor[] result = new IPropertyDescriptor[list.size()];
        list.toArray(result);
        return result;
    }

    public Object getPropertyValue(Object id) {
        String result = null;
        if (id instanceof String && ((String)id).equals("memberTypes")) {
            result = this.element.getAttribute((String)id);
            if (result == null) {
                result = "";
            }
            return result;
        }
        return "";
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (value == null) {
            value = "";
        }
        if (value instanceof String) {
            String newValue = (String)value;
            if (((String)id).equals("memberTypes")) {
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_LABEL_MEMBERTYPES_CHANGE"), this.element);
                if (newValue.length() > 0) {
                    this.element.setAttribute("memberTypes", (String)value);
                } else {
                    this.element.removeAttribute("memberTypes");
                }
                this.endRecording(this.element);
            }
        }
        Runnable delayedUpdate = new Runnable(){

            public void run() {
                if (SimpleTypeUnionPropertySource.this.viewer != null) {
                    SimpleTypeUnionPropertySource.this.viewer.refresh();
                }
            }
        };
        Display.getCurrent().asyncExec(delayedUpdate);
    }

    public class SimpleUnionMemberTypesPropertyDescriptor
    extends PropertyDescriptor {
        public SimpleUnionMemberTypesPropertyDescriptor(Object id, String displayName) {
            super(id, displayName);
        }

        public CellEditor createPropertyEditor(Composite parent) {
            SimpleTypeUnionMemberTypesDialogCellEditor editor = new SimpleTypeUnionMemberTypesDialogCellEditor(parent);
            if (this.getValidator() != null) {
                editor.setValidator(this.getValidator());
            }
            return editor;
        }
    }

    public class SimpleTypeUnionMemberTypesDialogCellEditor
    extends DialogCellEditor {
        protected SimpleTypeUnionMemberTypesDialogCellEditor(Composite parent) {
            super(parent);
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            Shell shell = Display.getCurrent().getActiveShell();
            SimpleContentUniontMemberTypesDialog dialog = new SimpleContentUniontMemberTypesDialog(shell);
            dialog.setBlockOnOpen(true);
            dialog.create();
            String value = (String)this.getValue();
            int result = dialog.open();
            if (result == 0) {
                return dialog.getResult();
            }
            return value;
        }
    }

    public class SimpleContentUniontMemberTypesDialog
    extends Dialog
    implements SelectionListener {
        Table table;
        TypeSection typeSection;
        Button addButton;
        Button removeButton;
        org.eclipse.swt.widgets.List memberTypesList;
        private String result;

        public SimpleContentUniontMemberTypesDialog(Shell shell) {
            super(shell);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                StringBuffer sb = new StringBuffer();
                int length = this.memberTypesList.getItemCount();
                int i = 0;
                while (i < length) {
                    sb.append(this.memberTypesList.getItem(i));
                    if (i < length - 1) {
                        sb.append(" ");
                    }
                    ++i;
                }
                this.result = sb.toString();
            }
            super.buttonPressed(buttonId);
        }

        public String getResult() {
            return this.result;
        }

        public Control createDialogArea(Composite parent) {
            Composite client = (Composite)super.createDialogArea(parent);
            this.getShell().setText("Union memberTypes");
            Label instructions = new Label(client, 16448);
            instructions.setText(XSDEditorPlugin.getXSDString("_UI_LABEL_SELECT_MEMBERTYPES"));
            Composite columnsComposite = new Composite(client, 0);
            GridLayout ccGL = new GridLayout();
            ccGL.verticalSpacing = 0;
            ccGL.horizontalSpacing = 0;
            ccGL.marginHeight = 0;
            ccGL.marginWidth = 0;
            ccGL.makeColumnsEqualWidth = true;
            ccGL.numColumns = 3;
            columnsComposite.setLayout((Layout)ccGL);
            GridData ccGD = new GridData();
            ccGD.grabExcessHorizontalSpace = true;
            ccGD.horizontalAlignment = 4;
            columnsComposite.setLayoutData((Object)ccGD);
            this.typeSection = new TypeSection(columnsComposite);
            this.typeSection.setShowUserComplexType(false);
            this.typeSection.createClient(columnsComposite);
            this.typeSection.getSimpleType().setSelection(false);
            this.typeSection.getSimpleType().addSelectionListener((SelectionListener)this);
            this.typeSection.getUserSimpleType().addSelectionListener((SelectionListener)this);
            ViewUtility.createHorizontalFiller(columnsComposite, 1);
            Label memberListLabel = new Label(columnsComposite, 16384);
            memberListLabel.setText(XSDEditorPlugin.getXSDString("_UI_LABEL_MEMBERTYPES_VALUE"));
            Composite dataComposite = new Composite(client, 0);
            GridLayout dcGL = new GridLayout();
            dcGL.verticalSpacing = 0;
            dcGL.marginHeight = 0;
            dcGL.marginWidth = 0;
            dcGL.numColumns = 3;
            dataComposite.setLayout((Layout)dcGL);
            GridData dcGD = new GridData();
            dcGD.grabExcessHorizontalSpace = true;
            dcGD.grabExcessVerticalSpace = true;
            dataComposite.setLayoutData((Object)dcGD);
            this.table = new Table(dataComposite, 68356);
            this.table.setHeaderVisible(false);
            this.table.setLinesVisible(true);
            GridData gd2 = new GridData();
            gd2.grabExcessHorizontalSpace = true;
            gd2.grabExcessVerticalSpace = true;
            gd2.horizontalAlignment = 4;
            gd2.verticalAlignment = 4;
            gd2.heightHint = 200;
            gd2.widthHint = 200;
            this.table.setLayoutData((Object)gd2);
            this.handleSetInput();
            this.table.getItemCount();
            TableColumn tc = new TableColumn(this.table, 16384);
            tc.setWidth(200);
            tc.setResizable(true);
            Composite buttonComposite = new Composite(dataComposite, 0);
            GridLayout bcGL = new GridLayout();
            bcGL.numColumns = 1;
            buttonComposite.setLayout((Layout)bcGL);
            this.addButton = new Button(buttonComposite, 8);
            this.addButton.setText(">");
            this.addButton.addSelectionListener((SelectionListener)this);
            this.removeButton = new Button(buttonComposite, 8);
            this.removeButton.setText("<");
            this.removeButton.addSelectionListener((SelectionListener)this);
            Composite listComposite = new Composite(dataComposite, 0);
            GridLayout mtGL = new GridLayout();
            mtGL.numColumns = 1;
            mtGL.marginHeight = 0;
            mtGL.marginWidth = 0;
            mtGL.horizontalSpacing = 0;
            mtGL.verticalSpacing = 0;
            listComposite.setLayout((Layout)mtGL);
            GridData mtGD = new GridData();
            mtGD.grabExcessHorizontalSpace = true;
            mtGD.grabExcessVerticalSpace = true;
            mtGD.verticalAlignment = 4;
            mtGD.horizontalAlignment = 4;
            listComposite.setLayoutData((Object)mtGD);
            this.memberTypesList = new org.eclipse.swt.widgets.List(listComposite, 2818);
            GridData mtlGD = new GridData();
            mtlGD.grabExcessHorizontalSpace = true;
            mtlGD.grabExcessVerticalSpace = true;
            mtlGD.verticalAlignment = 4;
            mtlGD.horizontalAlignment = 4;
            mtlGD.heightHint = 200;
            mtlGD.widthHint = 200;
            this.memberTypesList.setLayoutData((Object)mtlGD);
            this.initializeMemberListContent();
            return client;
        }

        private void initializeMemberListContent() {
            String result = SimpleTypeUnionPropertySource.this.element.getAttribute("memberTypes");
            if (result == null) {
                return;
            }
            StringTokenizer token = new StringTokenizer(result);
            while (token.hasMoreTokens()) {
                this.memberTypesList.add(token.nextToken());
            }
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.typeSection.getSimpleType() && this.typeSection.getSimpleType().getSelection()) {
                this.populateBuiltInType();
            } else if (e.widget == this.typeSection.getUserSimpleType() && this.typeSection.getUserSimpleType().getSelection()) {
                this.populateUserSimpleType(false);
            } else if (e.widget == this.addButton) {
                String typeToAdd;
                TableItem[] items = this.table.getItems();
                int selection = this.table.getSelectionIndex();
                if (items != null && items.length > 0 && selection >= 0 && this.memberTypesList.indexOf(typeToAdd = items[selection].getData().toString()) < 0) {
                    this.memberTypesList.add(items[selection].getData().toString());
                }
            } else if (e.widget == this.removeButton) {
                String[] typesToRemove = this.memberTypesList.getSelection();
                int i = 0;
                while (i < typesToRemove.length) {
                    this.memberTypesList.remove(typesToRemove[i]);
                    ++i;
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void handleSetInput() {
            this.populateBuiltInType();
        }

        public void populateBuiltInType() {
            this.table.removeAll();
            List items = this.getBuiltInTypeNamesList();
            int i = 0;
            while (i < items.size()) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(items.get(i).toString());
                item.setImage(XSDEditorPlugin.getXSDImage("icons/XSDSimpleType.gif"));
                item.setData(items.get(i));
                ++i;
            }
        }

        public void populateUserSimpleType(boolean showAnonymous) {
            this.table.removeAll();
            if (showAnonymous) {
                TableItem anonymousItem = new TableItem(this.table, 0);
                anonymousItem.setText("**anonymous**");
                anonymousItem.setData((Object)"**anonymous**");
            }
            List items = this.getUserSimpleTypeNamesList();
            int i = 0;
            while (i < items.size()) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(items.get(i).toString());
                item.setImage(XSDEditorPlugin.getXSDImage("icons/XSDSimpleType.gif"));
                item.setData(items.get(i));
                ++i;
            }
        }

        public List getBuiltInTypeNamesList() {
            TypesHelper helper = new TypesHelper(SimpleTypeUnionPropertySource.this.xsdSchema);
            return helper.getBuiltInTypeNamesList();
        }

        public List getUserSimpleTypeNamesList() {
            TypesHelper helper = new TypesHelper(SimpleTypeUnionPropertySource.this.xsdSchema);
            return helper.getUserSimpleTypeNamesList();
        }
    }
}

