/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import java.util.ArrayList;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.BasePropertySource;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.GlobalSimpleOrComplexTypeRenamer;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.w3c.dom.Node;

public class SimpleTypePropertySource
extends BasePropertySource
implements IPropertySource {
    private boolean isAnonymous = false;

    public SimpleTypePropertySource() {
    }

    public SimpleTypePropertySource(Viewer viewer, XSDSchema xsdSchema) {
        super(viewer, xsdSchema);
    }

    public SimpleTypePropertySource(XSDSchema xsdSchema) {
        super(xsdSchema);
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        Node parent = this.element.getParentNode();
        if (XSDDOMHelper.inputEquals(parent, "restriction", false) || XSDDOMHelper.inputEquals(parent, "element", false) || XSDDOMHelper.inputEquals(parent, "union", false) || XSDDOMHelper.inputEquals(parent, "list", false) || XSDDOMHelper.inputEquals(parent, "attribute", false)) {
            this.isAnonymous = true;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        if (!this.isAnonymous) {
            TextPropertyDescriptor nameDescriptor = new TextPropertyDescriptor((Object)"name", "name");
            list.add(nameDescriptor);
        } else {
            PropertyDescriptor readOnly = new PropertyDescriptor((Object)"name", "name");
            list.add(readOnly);
        }
        IPropertyDescriptor[] result = new IPropertyDescriptor[list.size()];
        list.toArray(result);
        return result;
    }

    public Object getPropertyValue(Object id) {
        String result = null;
        if (id instanceof String) {
            result = this.element.getAttribute((String)id);
            if (this.isAnonymous) {
                result = "**anonymous**";
            }
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        String name;
        if (value == null) {
            value = "";
        }
        if (value instanceof String && this.validateName(name = (String)value)) {
            this.beginRecording(XSDEditorPlugin.getXSDString("_UI_SIMPLETYPE_NAME_CHANGE"), this.element);
            if (name != null && name.length() > 0) {
                XSDConcreteComponent comp;
                if (this.xsdSchema != null && (comp = this.xsdSchema.getCorrespondingComponent((Node)this.element)) != null && comp instanceof XSDSimpleTypeDefinition && comp.getContainer().equals(this.xsdSchema)) {
                    GlobalSimpleOrComplexTypeRenamer renamer = new GlobalSimpleOrComplexTypeRenamer((XSDNamedComponent)comp, name);
                    renamer.visitSchema(this.xsdSchema);
                }
                this.element.setAttribute("name", name);
            } else {
                this.element.setAttribute("name", "");
            }
            this.endRecording(this.element);
        }
        Runnable delayedUpdate = new Runnable(){

            public void run() {
                if (SimpleTypePropertySource.this.viewer != null) {
                    SimpleTypePropertySource.this.viewer.refresh();
                }
            }
        };
        Display.getCurrent().asyncExec(delayedUpdate);
    }
}

