/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import java.util.ArrayList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.BasePropertySource;
import org.eclipse.wst.xsd.ui.internal.wizards.RegexWizard;
import org.eclipse.xsd.XSDSchema;

public class PatternPropertySource
extends BasePropertySource
implements IPropertySource {
    public PatternPropertySource() {
    }

    public PatternPropertySource(Viewer viewer, XSDSchema xsdSchema) {
        super(viewer, xsdSchema);
    }

    public PatternPropertySource(XSDSchema xsdSchema) {
        super(xsdSchema);
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<PatternTextPropertyDescriptor> list = new ArrayList<PatternTextPropertyDescriptor>();
        PatternTextPropertyDescriptor patternDescriptor = new PatternTextPropertyDescriptor("value", "value");
        list.add(patternDescriptor);
        IPropertyDescriptor[] result = new IPropertyDescriptor[list.size()];
        list.toArray(result);
        return result;
    }

    public Object getPropertyValue(Object id) {
        String result = null;
        if (id instanceof String) {
            result = this.element.getAttribute((String)id);
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (value == null) {
            value = "";
        }
        if (value instanceof String && ((String)id).equals("value")) {
            this.beginRecording(XSDEditorPlugin.getXSDString("_UI_PATTERN_VALUE_CHANGE"), this.element);
            this.element.setAttribute("value", (String)value);
            this.endRecording(this.element);
        }
        Runnable delayedUpdate = new Runnable(){

            public void run() {
                if (PatternPropertySource.this.viewer != null) {
                    PatternPropertySource.this.viewer.refresh();
                }
            }
        };
        Display.getCurrent().asyncExec(delayedUpdate);
    }

    public class PatternTextPropertyDescriptor
    extends PropertyDescriptor {
        public PatternTextPropertyDescriptor(Object id, String displayName) {
            super(id, displayName);
        }

        public CellEditor createPropertyEditor(Composite parent) {
            PatternDialogCellEditor editor = new PatternDialogCellEditor(parent);
            if (this.getValidator() != null) {
                editor.setValidator(this.getValidator());
            }
            return editor;
        }
    }

    public class PatternDialogCellEditor
    extends DialogCellEditor {
        protected PatternDialogCellEditor(Composite parent) {
            super(parent);
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            String initialValue = PatternPropertySource.this.element.getAttribute("value");
            if (initialValue == null) {
                initialValue = "";
            }
            RegexWizard wizard = new RegexWizard(initialValue);
            Shell shell = Display.getCurrent().getActiveShell();
            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
            wizardDialog.create();
            String value = (String)this.getValue();
            int result = wizardDialog.open();
            if (result == 0) {
                return wizard.getPattern();
            }
            return value;
        }
    }
}

