/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.SchemaDirectiveHelperPropertySource;
import org.eclipse.wst.xsd.ui.internal.refactor.delete.XSDExternalFileCleanup;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IncludePropertySource
extends SchemaDirectiveHelperPropertySource
implements IPropertySource {
    public IncludePropertySource(IFile currentIFile) {
        super(true);
        this.currentIFile = currentIFile;
    }

    public IncludePropertySource(Viewer viewer, XSDSchema xsdSchema, IFile currentIFile) {
        super(viewer, xsdSchema, true);
        this.currentIFile = currentIFile;
    }

    public IncludePropertySource(XSDSchema xsdSchema, IFile currentIFile) {
        super(xsdSchema, true);
        this.currentIFile = currentIFile;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<SchemaDirectiveHelperPropertySource.SchemaLocationPropertyDescriptor> list = new ArrayList<SchemaDirectiveHelperPropertySource.SchemaLocationPropertyDescriptor>();
        SchemaDirectiveHelperPropertySource.SchemaLocationPropertyDescriptor schemaLocationDescriptor = new SchemaDirectiveHelperPropertySource.SchemaLocationPropertyDescriptor(this, "schemaLocation", "schemaLocation");
        list.add(schemaLocationDescriptor);
        IPropertyDescriptor[] result = new IPropertyDescriptor[list.size()];
        list.toArray(result);
        return result;
    }

    public Object getPropertyValue(Object id) {
        String result = null;
        if (id instanceof String) {
            result = this.element.getAttribute((String)id);
            String cfr_ignored_0 = (String)id;
            if (result == null) {
                result = "";
            }
            return result;
        }
        return "";
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (value == null) {
            value = "";
        }
        if (value instanceof String && ((String)id).equals("schemaLocation")) {
            this.updateExternalModel((String)value, this.selectedIFile, this.selectedNamespace, this.selectedXSDSchema);
        }
        Runnable delayedUpdate = new Runnable(){

            public void run() {
                if (IncludePropertySource.this.viewer != null) {
                    IncludePropertySource.this.viewer.refresh();
                }
            }
        };
        Display.getCurrent().asyncExec(delayedUpdate);
    }

    protected void updateExternalModel(String newLocation, IFile newFile, String namespace, XSDSchema externalSchema) {
        XSDInclude include;
        XSDSchema referencedSchema;
        Element includeElement = this.element;
        String existingSchemaLocation = includeElement.getAttribute("schemaLocation");
        this.beginRecording(XSDEditorPlugin.getXSDString("_UI_LABEL_INCLUDE_CHANGE"), includeElement);
        includeElement.setAttribute("schemaLocation", newLocation);
        if (existingSchemaLocation == null) {
            return;
        }
        XSDConcreteComponent includeComponent = this.xsdSchema.getCorrespondingComponent((Node)includeElement);
        if (includeComponent instanceof XSDInclude && (referencedSchema = (include = (XSDInclude)includeComponent).getResolvedSchema()) != null) {
            XSDExternalFileCleanup cleanHelper = new XSDExternalFileCleanup(referencedSchema);
            cleanHelper.visitSchema(this.xsdSchema);
            this.xsdSchema.update();
            include.updateElement();
        }
        this.endRecording(includeElement);
    }
}

