/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.provisional.NameValidator;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BasePropertySource
implements IPropertySource {
    protected Element element;
    protected Viewer viewer;
    protected IPropertyDescriptor[] propertyDescriptors;
    protected XSDSchema xsdSchema;
    protected String[] trueFalseComboValues = new String[]{"", "false", "true"};
    protected XSDDOMHelper domHelper = new XSDDOMHelper();

    public BasePropertySource() {
    }

    public DocumentImpl getDocument(Element element) {
        return (DocumentImpl)element.getOwnerDocument();
    }

    public void beginRecording(String description, Element element) {
        this.getDocument(element).getModel().beginRecording((Object)this, description);
    }

    public void endRecording(Element element) {
        DocumentImpl doc = this.getDocument(element);
        doc.getModel().endRecording((Object)this);
    }

    public BasePropertySource(Viewer viewer, XSDSchema xsdSchema) {
        this.viewer = viewer;
        this.xsdSchema = xsdSchema;
    }

    public BasePropertySource(XSDSchema xsdSchema) {
        this.xsdSchema = xsdSchema;
    }

    public void setViewer(Viewer viewer) {
        this.viewer = viewer;
    }

    public void setInput(Element element) {
        this.element = element;
    }

    public XSDDOMHelper getDomHelper() {
        return this.domHelper;
    }

    protected boolean hasElementChildren(Node parentNode) {
        boolean hasChildrenElements = false;
        if (parentNode != null && parentNode.hasChildNodes()) {
            NodeList nodes = parentNode.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                if (nodes.item(i) instanceof Element) {
                    hasChildrenElements = true;
                    break;
                }
                ++i;
            }
        }
        return hasChildrenElements;
    }

    protected boolean validateName(String name) {
        return NameValidator.isValid((String)name);
    }

    protected boolean validateLanguage(String lang) {
        return true;
    }

    protected boolean validatePrefix(String prefix) {
        return true;
    }
}

