/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.graph.XSDChildUtility;
import org.eclipse.wst.xsd.ui.internal.graph.model.Category;
import org.eclipse.wst.xsd.ui.internal.graph.model.ModelAdapter;
import org.eclipse.wst.xsd.ui.internal.graph.model.ModelAdapterListener;
import org.eclipse.wst.xsd.ui.internal.provider.XSDAbstractAdapter;
import org.eclipse.wst.xsd.ui.internal.provider.XSDModelAdapterFactoryImpl;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.util.XSDSwitch;

public class XSDModelAdapterFactory {
    protected static XSDModelAdapterFactory instance;
    protected static XSDAdapterFactoryImpl xsdAdapterFactoryImpl;

    static {
        xsdAdapterFactoryImpl = new XSDAdapterFactoryImpl();
    }

    public static XSDModelAdapterFactory getInstance() {
        if (instance == null) {
            instance = new XSDModelAdapterFactory();
        }
        return instance;
    }

    public static ModelAdapter getAdapter(Object o) {
        ModelAdapter result = null;
        if (o instanceof Notifier) {
            Notifier target = (Notifier)o;
            Adapter adapter = xsdAdapterFactoryImpl.adapt(target);
            if (adapter instanceof XSDObjectAdapter) {
                result = (XSDObjectAdapter)adapter;
            }
        } else if (o instanceof ModelAdapter) {
            result = (ModelAdapter)o;
        }
        return result;
    }

    public static XSDObjectAdapter getExisitingAdapter(Object xsdObject) {
        Notifier target;
        Adapter adapter;
        XSDObjectAdapter result = null;
        if (xsdObject instanceof Notifier && (adapter = EcoreUtil.getExistingAdapter((Notifier)(target = (Notifier)xsdObject), (Object)((Object)xsdAdapterFactoryImpl))) instanceof XSDObjectAdapter) {
            result = (XSDObjectAdapter)adapter;
        }
        return result;
    }

    public static void addModelAdapterListener(Object modelObject, ModelAdapterListener listener) {
        ModelAdapter modelAdapter = XSDModelAdapterFactory.getModelAdapter(modelObject);
        if (modelAdapter != null) {
            modelAdapter.addListener(listener);
        }
    }

    public static void removeModelAdapterListener(Object modelObject, ModelAdapterListener listener) {
        ModelAdapter modelAdapter = XSDModelAdapterFactory.getModelAdapter(modelObject);
        if (modelAdapter != null) {
            modelAdapter.removeListener(listener);
        }
    }

    protected static ModelAdapter getModelAdapter(Object modelObject) {
        ModelAdapter modelAdapter = null;
        if (modelObject instanceof Notifier) {
            modelAdapter = (ModelAdapter)xsdAdapterFactoryImpl.adapt((Notifier)modelObject);
        } else if (modelObject instanceof ModelAdapter) {
            modelAdapter = (ModelAdapter)modelObject;
        }
        return modelAdapter;
    }

    public static class XSDAdapterFactoryImpl
    extends AdapterFactoryImpl {
        public Adapter createAdapter(Notifier target) {
            XSDSwitch xsdSwitch = new XSDSwitch(this){
                final /* synthetic */ XSDAdapterFactoryImpl this$1;
                {
                    this.this$1 = xSDAdapterFactoryImpl;
                }

                public Object caseXSDElementDeclaration(XSDElementDeclaration object) {
                    return new XSDElementDeclarationAdapter(object);
                }

                public Object caseXSDParticle(XSDParticle object) {
                    return new XSDParticleAdapter(object);
                }

                public Object caseXSDSchema(XSDSchema object) {
                    return new XSDSchemaAdapter(object);
                }

                public Object defaultCase(EObject object) {
                    return new XSDObjectAdapter();
                }
            };
            Object o = xsdSwitch.doSwitch((EObject)target);
            Adapter result = null;
            if (o instanceof Adapter) {
                result = (Adapter)o;
            }
            return result;
        }

        public Adapter adapt(Notifier target) {
            return this.adapt(target, (Object)this);
        }
    }

    protected static class XSDObjectAdapter
    extends AdapterImpl
    implements ModelAdapter {
        protected List listenerList = new ArrayList();
        protected boolean isUpdating = false;

        protected XSDObjectAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return type == xsdAdapterFactoryImpl;
        }

        public void addListener(ModelAdapterListener l) {
            this.listenerList.add(l);
        }

        public void removeListener(ModelAdapterListener l) {
            this.listenerList.remove(l);
        }

        public Object getProperty(Object modelObject, String propertyName) {
            Object result = null;
            if ("LABEL_PROPERTY".equals(propertyName)) {
                result = "";
                if (modelObject instanceof XSDNamedComponent) {
                    result = ((XSDNamedComponent)modelObject).getName();
                } else if (modelObject instanceof XSDSchemaDirective) {
                    result = ((XSDSchemaDirective)modelObject).getSchemaLocation();
                    if (result == null) {
                        result = "(" + XSDEditorPlugin.getXSDString("_UI_LABEL_NO_LOCATION_SPECIFIED") + ")";
                    }
                    if (result.equals("")) {
                        result = "(" + XSDEditorPlugin.getXSDString("_UI_LABEL_NO_LOCATION_SPECIFIED") + ")";
                    }
                    return result;
                }
            } else if ("drillDown".equals(propertyName)) {
                List list = XSDChildUtility.getModelChildren(modelObject);
                result = list.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
            } else if ("IMAGE_PROPERTY".equals(propertyName)) {
                XSDModelAdapterFactoryImpl factory = XSDModelAdapterFactoryImpl.getInstance();
                Adapter adapter = factory.createAdapter((Notifier)modelObject);
                result = ((XSDAbstractAdapter)adapter).getImage(modelObject);
            }
            return result;
        }

        public void firePropertyChanged(Object modelObject, String propertyName) {
            ArrayList newList = new ArrayList();
            newList.addAll(this.listenerList);
            Iterator i = newList.iterator();
            while (i.hasNext()) {
                ModelAdapterListener l = (ModelAdapterListener)i.next();
                try {
                    l.propertyChanged(modelObject, propertyName);
                }
                catch (Exception exception) {}
            }
        }

        public void notifyChanged(Notification msg) {
            this.firePropertyChanged(msg.getNotifier(), null);
        }
    }

    protected static class XSDParticleAdapter
    extends XSDObjectAdapter
    implements ModelAdapterListener {
        protected XSDParticle particle;

        public XSDParticleAdapter(XSDParticle particle) {
            this.particle = particle;
        }

        public void notifyChanged(Notification msg) {
            XSDParticle xsdParticle = (XSDParticle)msg.getNotifier();
            XSDParticleContent xsdParticleContent = xsdParticle.getContent();
            XSDModelAdapterFactoryImpl factory = XSDModelAdapterFactoryImpl.getInstance();
            if (xsdParticleContent != null) {
                if (xsdParticleContent instanceof XSDElementDeclaration) {
                    this.firePropertyChanged((XSDElementDeclaration)xsdParticleContent, null);
                    factory.fireNotifyChanged(msg);
                } else if (xsdParticleContent instanceof XSDModelGroup) {
                    this.firePropertyChanged((XSDModelGroup)xsdParticleContent, null);
                    factory.fireNotifyChanged(msg);
                } else if (xsdParticleContent instanceof XSDWildcard) {
                    this.firePropertyChanged((XSDWildcard)xsdParticleContent, null);
                    factory.fireNotifyChanged(msg);
                }
            }
        }

        public void propertyChanged(Object object, String property) {
            this.firePropertyChanged(object, property);
        }
    }

    protected static class XSDElementDeclarationAdapter
    extends XSDObjectAdapter
    implements ModelAdapterListener {
        protected XSDElementDeclaration ed;
        protected XSDTypeDefinition typeDefinition;

        public XSDElementDeclarationAdapter(XSDElementDeclaration ed) {
            this.ed = ed;
            this.updateTypeDefinition();
        }

        protected void updateTypeDefinition() {
            XSDTypeDefinition td = this.ed.getTypeDefinition();
            Object object = td = td instanceof XSDComplexTypeDefinition ? td : null;
            if (td != this.typeDefinition) {
                XSDObjectAdapter adapter;
                if (this.typeDefinition != null) {
                    adapter = (XSDObjectAdapter)xsdAdapterFactoryImpl.adapt((Notifier)this.typeDefinition);
                    adapter.removeListener(this);
                }
                this.typeDefinition = td;
                if (this.typeDefinition != null) {
                    adapter = (XSDObjectAdapter)xsdAdapterFactoryImpl.adapt((Notifier)this.typeDefinition);
                    adapter.addListener(this);
                }
            }
        }

        public void notifyChanged(Notification msg) {
            this.updateTypeDefinition();
            this.firePropertyChanged(msg.getNotifier(), null);
        }

        public void propertyChanged(Object object, String property) {
            this.firePropertyChanged(object, property);
        }
    }

    protected static class XSDSchemaAdapter
    extends XSDObjectAdapter {
        protected XSDSchema schema;
        protected List groups;

        public XSDSchemaAdapter(XSDSchema schema) {
            this.schema = schema;
            this.groups = new ArrayList();
            this.groups.add(new Category(schema, 6));
            this.groups.add(new Category(schema, 1));
            this.groups.add(new Category(schema, 2));
            this.groups.add(new Category(schema, 3));
            this.groups.add(new Category(schema, 5));
        }

        public void notifyChanged(Notification msg) {
            super.notifyChanged(msg);
            Iterator i = this.groups.iterator();
            while (i.hasNext()) {
                ModelAdapter group = (ModelAdapter)i.next();
                group.firePropertyChanged(group, null);
            }
        }

        public Object getProperty(Object modelObject, String propertyName) {
            Object result = null;
            if ("groups".equals(propertyName)) {
                result = this.groups;
            }
            if (result == null) {
                result = super.getProperty(modelObject, propertyName);
            }
            return result;
        }
    }
}

