/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wst.xsd.ui.internal.graph.figures.ContainerFigure;
import org.eclipse.wst.xsd.ui.internal.graph.figures.FloatableFigure;
import org.eclipse.wst.xsd.ui.internal.graph.figures.GraphNodeContainerFigure;
import org.eclipse.wst.xsd.ui.internal.graph.figures.Interactor;
import org.eclipse.wst.xsd.ui.internal.graph.figures.RepeatableGraphNodeFigure;

public class ExpandableGraphNodeFigure
extends RepeatableGraphNodeFigure {
    protected ContainerFigure horizontalGroup;
    protected Interactor interactor;
    protected ContainerFigure outerContentArea;

    public boolean isExpanded() {
        return this.interactor.isExpanded();
    }

    public void setExpanded(boolean isExpanded) {
        this.interactor.setExpanded(isExpanded);
    }

    public ExpandableGraphNodeFigure() {
        this.isConnected = true;
    }

    protected void createFigure() {
        this.createPreceedingSpace((IFigure)this);
        this.createVerticalGroup((IFigure)this);
        this.createHorizontalGroup((IFigure)this.verticalGroup);
        this.createOutlinedArea((IFigure)this.horizontalGroup);
        this.createInteractor((IFigure)this.horizontalGroup);
        this.createOccurenceArea((IFigure)this.verticalGroup);
        this.createOuterContentArea((IFigure)this);
    }

    protected void createVerticalGroup(IFigure parent) {
        this.verticalGroup = new FloatableFigure(this);
        this.verticalGroup.getContainerLayout().setHorizontal(false);
        parent.add((IFigure)this.verticalGroup);
    }

    protected void createHorizontalGroup(IFigure parent) {
        this.horizontalGroup = new ContainerFigure();
        parent.add((IFigure)this.horizontalGroup);
    }

    protected void createInteractor(IFigure parent) {
        this.interactor = new Interactor();
        this.interactor.setForegroundColor(ColorConstants.black);
        this.interactor.setBackgroundColor(ColorConstants.white);
        parent.add((IFigure)this.interactor);
    }

    protected void createOuterContentArea(IFigure parent) {
        RectangleFigure space = new RectangleFigure();
        space.setVisible(false);
        space.setPreferredSize(new Dimension(5, 10));
        parent.add((IFigure)space);
        this.outerContentArea = new GraphNodeContainerFigure(this);
        this.outerContentArea.getContainerLayout().setHorizontal(false);
        parent.add((IFigure)this.outerContentArea);
    }

    public Interactor getInteractor() {
        return this.interactor;
    }

    public ContainerFigure getOuterContentArea() {
        return this.outerContentArea;
    }

    public IFigure getConnectionFigure() {
        return this.horizontalGroup;
    }

    public Rectangle getConnectionRectangle() {
        return this.horizontalGroup.getBounds();
    }
}

