/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph.figures;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class CenterLayout
extends AbstractLayout {
    protected int spacing;

    public CenterLayout() {
    }

    public CenterLayout(int spacing) {
        this.spacing = spacing;
    }

    protected Dimension calculatePreferredSize(IFigure figure, int w, int h) {
        Dimension d = this.calculatePreferredClientAreaSize(figure);
        d.expand(w, h);
        d.union(this.getBorderPreferredSize(figure));
        return d;
    }

    protected Dimension calculatePreferredClientAreaSize(IFigure figure) {
        Dimension d = new Dimension();
        List children = figure.getChildren();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            IFigure child = (IFigure)i.next();
            Dimension childSize = child.getPreferredSize();
            d.height += childSize.height;
            d.width = Math.max(childSize.width, d.width);
        }
        int childrenSize = children.size();
        if (childrenSize > 0) {
            d.height += this.spacing * children.size() - 1;
        }
        return d;
    }

    public Dimension getMinimumSize(IFigure figure, int wHint, int hHint) {
        Dimension d = new Dimension();
        List children = figure.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            d.union(child.getMinimumSize());
            ++i;
        }
        d.expand(figure.getInsets().getWidth(), figure.getInsets().getHeight());
        return d;
    }

    public Dimension getPreferredSize(IFigure figure, int wHint, int hHint) {
        return this.calculatePreferredSize(figure, wHint, hHint);
    }

    public void layout(IFigure figure) {
        Rectangle r = figure.getClientArea();
        List children = figure.getChildren();
        Dimension preferredClientAreaSize = this.calculatePreferredClientAreaSize(figure);
        int x = r.x + (r.width - preferredClientAreaSize.width) / 2;
        int y = r.y + (r.height - preferredClientAreaSize.height) / 2;
        Iterator i = children.iterator();
        while (i.hasNext()) {
            IFigure child = (IFigure)i.next();
            Dimension childSize = child.getPreferredSize();
            child.setBounds(new Rectangle(x, y, childSize.width, childSize.height));
            y += childSize.height + this.spacing;
        }
    }
}

