/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph.editparts;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.wst.xsd.ui.internal.graph.XSDInheritanceViewer;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.BaseEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.CategoryEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.ComplexTypeDefinitionEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.ElementDeclarationEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.ModelGroupDefinitionEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.ModelGroupEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.RootComplexTypeDefinitionEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.RootModelGroupDefinitionEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.SchemaEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.SimpleTypeDefinitionEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.WildcardEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.model.Category;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDWildcard;

public class XSDEditPartFactory
implements EditPartFactory {
    protected static XSDEditPartFactory instance;

    public static XSDEditPartFactory getInstance() {
        if (instance == null) {
            instance = new XSDEditPartFactory();
        }
        return instance;
    }

    public EditPart createEditPart(EditPart parent, Object model) {
        BaseEditPart editPart = null;
        if (model instanceof Category) {
            editPart = new CategoryEditPart();
        } else if (model instanceof XSDElementDeclaration) {
            editPart = new ElementDeclarationEditPart();
        } else if (model instanceof XSDComplexTypeDefinition) {
            editPart = parent.getViewer() instanceof XSDInheritanceViewer ? new RootComplexTypeDefinitionEditPart() : (parent instanceof CategoryEditPart ? new RootComplexTypeDefinitionEditPart() : new ComplexTypeDefinitionEditPart());
        } else if (model instanceof XSDModelGroup) {
            editPart = new ModelGroupEditPart();
        } else if (model instanceof XSDModelGroupDefinition) {
            editPart = parent instanceof CategoryEditPart ? new RootModelGroupDefinitionEditPart() : new ModelGroupDefinitionEditPart();
        } else if (model instanceof XSDSchema) {
            editPart = new SchemaEditPart();
        } else if (model instanceof XSDWildcard) {
            editPart = new WildcardEditPart();
        } else if (model instanceof XSDSimpleTypeDefinition) {
            editPart = new SimpleTypeDefinitionEditPart();
        }
        if (editPart != null) {
            editPart.setModel(model);
            editPart.setParent(parent);
        }
        return editPart;
    }
}

