/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.wst.xsd.ui.internal.gef.util.figures.ConnectedEditPartFigure;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.BaseEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editpolicies.GraphNodeDragTracker;
import org.eclipse.wst.xsd.ui.internal.graph.editpolicies.SelectionHandlesEditPolicyImpl;
import org.eclipse.wst.xsd.ui.internal.graph.figures.GraphNodeFigure;

public abstract class GraphNodeEditPart
extends BaseEditPart {
    protected GraphNodeFigure graphNodeFigure;
    protected SelectionHandlesEditPolicyImpl selectionHandlesEditPolicy;

    protected boolean isConnectedEditPart() {
        return true;
    }

    protected IFigure createFigure() {
        this.graphNodeFigure = this.createGraphNodeFigure();
        RectangleFigure result = this.graphNodeFigure;
        this.addGraphNodeFigureListeners();
        if (this.isConnectedEditPart()) {
            ConnectedEditPartFigure connectedEditPartFigure = this.createConnectedEditPartFigure();
            connectedEditPartFigure.add((IFigure)this.graphNodeFigure);
            result = connectedEditPartFigure;
        }
        return result;
    }

    protected ConnectedEditPartFigure createConnectedEditPartFigure() {
        ConnectedEditPartFigure connectedEditPartFigure = new ConnectedEditPartFigure((EditPart)this){

            public IFigure getSelectionFigure() {
                return GraphNodeEditPart.this.graphNodeFigure.getOutlinedArea();
            }

            public IFigure getConnectionFigure() {
                return GraphNodeEditPart.this.graphNodeFigure.getConnectionFigure();
            }
        };
        return connectedEditPartFigure;
    }

    protected abstract GraphNodeFigure createGraphNodeFigure();

    protected void addGraphNodeFigureListeners() {
    }

    public IFigure getSelectionFigure() {
        return this.graphNodeFigure.getOutlinedArea();
    }

    public Rectangle getConnectionRectangle() {
        return this.graphNodeFigure.getConnectionRectangle();
    }

    protected void createEditPolicies() {
        this.selectionHandlesEditPolicy = new SelectionHandlesEditPolicyImpl();
        this.installEditPolicy("Selection Feedback", (EditPolicy)this.selectionHandlesEditPolicy);
    }

    public DragTracker getDragTracker(Request request) {
        return new GraphNodeDragTracker((EditPart)this);
    }

    protected EditPart getApplicableEditPart(EditPart editPart, Point p) {
        while (true) {
            IFigure f;
            EditPart parent = null;
            if (editPart instanceof GraphNodeEditPart && !this.hitTest(f = ((GraphNodeEditPart)editPart).getSelectionFigure(), p)) {
                parent = editPart.getParent();
            }
            if (parent == null) break;
            editPart = parent;
        }
        return editPart;
    }

    public EditPart getTargetEditPart(Request request) {
        EditPart editPart = null;
        if (request.getType() == "selection" && request instanceof LocationRequest) {
            LocationRequest locationRequest = (LocationRequest)request;
            Point p = locationRequest.getLocation();
            editPart = this.getApplicableEditPart((EditPart)this, p);
        }
        return editPart != null ? editPart : super.getTargetEditPart(request);
    }

    public boolean hitTest(IFigure target, Point location) {
        Rectangle b = target.getBounds().getCopy();
        target.translateToAbsolute((Translatable)b);
        return b.contains(location);
    }
}

