/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsd.ui.internal.XSDEditor;
import org.eclipse.wst.xsd.ui.internal.graph.BaseGraphicalViewer;
import org.eclipse.wst.xsd.ui.internal.util.ViewUtility;
import org.eclipse.xsd.XSDConcreteComponent;
import org.w3c.dom.Element;

public class LinkedGraphViewer {
    protected ISelectionProvider menuSelectionProvider;
    protected XSDEditor editor;
    protected BaseGraphicalViewer majorViewer;
    protected BaseGraphicalViewer minorViewer;
    protected Composite control;
    protected SashForm sashForm;
    protected MajorViewerSelectionChangedListener majorViewerListener = new MajorViewerSelectionChangedListener();

    public LinkedGraphViewer(XSDEditor editor, ISelectionProvider selectionProvider) {
        this.menuSelectionProvider = selectionProvider;
        this.editor = editor;
    }

    public void setMajorViewer(BaseGraphicalViewer majorViewer) {
        this.majorViewer = majorViewer;
    }

    public void setMinorViewer(BaseGraphicalViewer minorViewer) {
        this.minorViewer = minorViewer;
    }

    public Control createControl(Composite parent) {
        this.sashForm = new SashForm(parent, 2560);
        this.control = this.sashForm;
        this.sashForm.setLayoutData((Object)ViewUtility.createFill());
        this.majorViewer.createControl((Composite)this.sashForm);
        this.minorViewer.createControl((Composite)this.sashForm);
        return this.control;
    }

    public void addSelectionChangedListener(ISelectionChangedListener selectionListener) {
        if (this.majorViewer != null) {
            this.majorViewer.addSelectionChangedListener(selectionListener);
            this.majorViewer.addSelectionChangedListener(this.majorViewerListener);
        }
        if (this.minorViewer != null) {
            this.minorViewer.addSelectionChangedListener(selectionListener);
        }
    }

    public Composite getControl() {
        return this.control;
    }

    protected XSDConcreteComponent getInput() {
        return this.majorViewer.getInput();
    }

    protected void setInput(XSDConcreteComponent input) {
        this.majorViewer.setInput(input);
        this.minorViewer.setInput(input);
    }

    public void setSelection(XSDConcreteComponent component) {
        this.majorViewer.setSelection(component);
    }

    private class MajorViewerSelectionChangedListener
    implements ISelectionChangedListener {
        MajorViewerSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection editPartSelection = event.getSelection();
            new ArrayList();
            if (editPartSelection instanceof IStructuredSelection) {
                Iterator i = ((IStructuredSelection)editPartSelection).iterator();
                while (i.hasNext()) {
                    Element element;
                    Object model;
                    EditPart editPart = (EditPart)i.next();
                    if (editPart == null || !((model = editPart.getModel()) instanceof XSDConcreteComponent) || !((element = ((XSDConcreteComponent)model).getElement()) instanceof IDOMNode)) continue;
                    LinkedGraphViewer.this.minorViewer.setInput((XSDConcreteComponent)model);
                    LinkedGraphViewer.this.minorViewer.setSelection((XSDConcreteComponent)model);
                }
            }
        }
    }
}

