/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;

public class XSDURIConverter
extends URIConverterImpl {
    IFile resourceFile;

    public XSDURIConverter(IFile resourceFile) {
        this.resourceFile = resourceFile;
    }

    public InputStream createInputStream(URI uri) throws IOException {
        String scheme = uri.scheme();
        URI mappedURI = uri;
        if (scheme != null && !scheme.equals("file") && !scheme.equals("platform")) {
            String theURI = uri.toString();
            URIResolver idResolver = URIResolverPlugin.createResolver();
            String result = idResolver.resolve("/", null, theURI);
            if (result != null) {
                mappedURI = XSDURIConverter.createURI(result);
            }
        }
        return super.createURLInputStream(mappedURI);
    }

    public static URI createURI(String uriString) {
        if (XSDURIConverter.hasProtocol(uriString)) {
            return URI.createURI((String)uriString);
        }
        return URI.createFileURI((String)uriString);
    }

    private static boolean hasProtocol(String uri) {
        int index;
        boolean result = false;
        if (uri != null && (index = uri.indexOf(":")) != -1 && index > 2) {
            result = true;
        }
        return result;
    }

    private String getRelativePathToSchema(String a, String b) {
        if (b.startsWith(a)) {
            String result = b.substring(a.length() + 1);
            return result;
        }
        return b;
    }
}

