/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.osgi.framework.Bundle;

public class XSDEditorPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.wst.xsd.ui";
    public static final String XSD_EDITOR_ID = "org.eclipse.wst.xsd.ui.XSDEditor";
    public static final String DEFAULT_TARGET_NAMESPACE = "http://www.example.org";
    protected static XSDEditorPlugin plugin;
    public static final String CONST_XSD_DEFAULT_PREFIX_TEXT = "org.eclipse.wst.xmlschema.xsdDefaultPrefixText";
    public static final String CONST_XSD_LANGUAGE_QUALIFY = "org.eclipse.wst.xmlschema.xsdQualify";
    public static final String CONST_DEFAULT_TARGET_NAMESPACE = "org.eclipse.wst.xmlschema.defaultTargetnamespaceText";
    public static String DEFAULT_PAGE;
    public static String DESIGN_PAGE;
    public static String SOURCE_PAGE;
    public static String GRAPH_PAGE;
    public static String EDITOR_LAYOUT;
    public static String COMBINED_LAYOUT;
    public static String SEPARATE_LAYOUT;
    public static String DESIGN_LAYOUT;
    public static String TOP_LAYOUT;
    public static String BOTTOM_LAYOUT;
    public static String LEFT_LAYOUT;
    public static String RIGHT_LAYOUT;
    protected URL baseURL;

    static {
        DEFAULT_PAGE = "org.eclipse.wst.xsd.ui.internal.defaultPage";
        DESIGN_PAGE = "org.eclipse.wst.xsd.ui.internal.designPage";
        SOURCE_PAGE = "org.eclipse.wst.xsd.ui.internal.sourcePage";
        GRAPH_PAGE = "org.eclipse.wst.xsd.ui.internal.graphPage";
        EDITOR_LAYOUT = "org.eclipse.wst.xsd.ui.internal.editorlayout";
        COMBINED_LAYOUT = "org.eclipse.wst.xsd.ui.internal.combined";
        SEPARATE_LAYOUT = "org.eclipse.wst.xsd.ui.internal.separate";
        DESIGN_LAYOUT = "org.eclipse.wst.xsd.ui.internal.designlayout";
        TOP_LAYOUT = "org.eclipse.wst.xsd.ui.internal.top";
        BOTTOM_LAYOUT = "org.eclipse.wst.xsd.ui.internal.bottom";
        LEFT_LAYOUT = "org.eclipse.wst.xsd.ui.internal.left";
        RIGHT_LAYOUT = "org.eclipse.wst.xsd.ui.internal.right";
    }

    public XSDEditorPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public void startup() throws CoreException {
        super.startup();
    }

    public static IModelManager getModelManager() {
        return StructuredModelManager.getModelManager();
    }

    public static URL getInstallURL() {
        return XSDEditorPlugin.getPlugin().getDescriptor().getInstallURL();
    }

    public static IPath getPluginLocation() {
        try {
            IPath installPath = new Path(XSDEditorPlugin.getInstallURL().toExternalForm()).removeTrailingSeparator();
            String installStr = Platform.asLocalURL((URL)new URL(installPath.toString())).getFile();
            return new Path(installStr);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getMetaDataDirectory() {
        return XSDEditorPlugin.getPlugin().getStateLocation().toOSString();
    }

    public static XSDEditorPlugin getPlugin() {
        return plugin;
    }

    public static Image getXSDImage(String iconName) {
        return XSDEditorPlugin.getPlugin().getImage(iconName);
    }

    public Image getImage(String iconName) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        if (imageRegistry.get(iconName) != null) {
            return imageRegistry.get(iconName);
        }
        imageRegistry.put(iconName, ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)iconName));
        return imageRegistry.get(iconName);
    }

    public static String getXSDString(String key) {
        return Platform.getResourceBundle((Bundle)plugin.getBundle()).getString(key);
    }

    public String getString(String key, Object s1) {
        return MessageFormat.format(Platform.getResourceBundle((Bundle)this.getBundle()).getString(key), s1);
    }

    public static Shell getShell() {
        return XSDEditorPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public String getXMLSchemaPrefix() {
        return this.getPreferenceStore().getString(CONST_XSD_DEFAULT_PREFIX_TEXT);
    }

    public String getXMLSchemaTargetNamespace() {
        String targetNamespace = this.getPreferenceStore().getString(CONST_DEFAULT_TARGET_NAMESPACE);
        if (!targetNamespace.endsWith("/")) {
            targetNamespace = String.valueOf(targetNamespace) + "/";
        }
        return targetNamespace;
    }

    public boolean isQualifyXMLSchemaLanguage() {
        return this.getPreferenceStore().getBoolean(CONST_XSD_LANGUAGE_QUALIFY);
    }

    public boolean isCombinedDesignAndSourceView() {
        return COMBINED_LAYOUT.equals(this.getPreferenceStore().getString(EDITOR_LAYOUT));
    }

    public int getDesignLayout() {
        if (TOP_LAYOUT.equals(this.getPreferenceStore().getString(DESIGN_LAYOUT))) {
            return 512;
        }
        if (BOTTOM_LAYOUT.equals(this.getPreferenceStore().getString(DESIGN_LAYOUT))) {
            return 512;
        }
        if (LEFT_LAYOUT.equals(this.getPreferenceStore().getString(DESIGN_LAYOUT))) {
            return 256;
        }
        if (RIGHT_LAYOUT.equals(this.getPreferenceStore().getString(DESIGN_LAYOUT))) {
            return 256;
        }
        return 256;
    }

    public String getDesignLayoutPosition() {
        if (TOP_LAYOUT.equals(this.getPreferenceStore().getString(DESIGN_LAYOUT))) {
            return TOP_LAYOUT;
        }
        if (BOTTOM_LAYOUT.equals(this.getPreferenceStore().getString(DESIGN_LAYOUT))) {
            return BOTTOM_LAYOUT;
        }
        if (LEFT_LAYOUT.equals(this.getPreferenceStore().getString(DESIGN_LAYOUT))) {
            return LEFT_LAYOUT;
        }
        if (RIGHT_LAYOUT.equals(this.getPreferenceStore().getString(DESIGN_LAYOUT))) {
            return RIGHT_LAYOUT;
        }
        return RIGHT_LAYOUT;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        super.initializeDefaultPreferences(store);
        store.setDefault(CONST_XSD_DEFAULT_PREFIX_TEXT, "xsd");
        store.setDefault(CONST_XSD_LANGUAGE_QUALIFY, false);
        store.setDefault(DEFAULT_PAGE, DESIGN_PAGE);
        store.setDefault(EDITOR_LAYOUT, COMBINED_LAYOUT);
        store.setDefault(DESIGN_LAYOUT, RIGHT_LAYOUT);
        store.setDefault(CONST_DEFAULT_TARGET_NAMESPACE, DEFAULT_TARGET_NAMESPACE);
    }

    public void setDefaultPage(String page) {
        this.getPreferenceStore().setValue(DEFAULT_PAGE, page);
    }

    public String getDefaultPage() {
        return this.getPreferenceStore().getString(DEFAULT_PAGE);
    }

    public URL getBaseURL() {
        return this.getDescriptor().getInstallURL();
    }

    public Image getIconImage(String object) {
        try {
            return ExtendedImageRegistry.getInstance().getImage((Object)new URL(this.getBaseURL() + "icons/" + object + ".gif"));
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Failed to load image for '" + object + "'");
            return null;
        }
    }
}

