/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.wizard.ClassesImportWizard;
import org.eclipse.jst.j2ee.internal.wizard.ImportUtil;
import org.eclipse.jst.j2ee.internal.wizard.MinimizedFileSystemElement;
import org.eclipse.jst.j2ee.internal.wizard.PackageNameResolver;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.dialogs.WizardResourceImportPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.ide.dialogs.IElementFilter;
import org.eclipse.ui.internal.ide.dialogs.ResourceTreeAndListGroup;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerSorter;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

class WizardClassesImportPage1
extends WizardResourceImportPage
implements Listener {
    protected Combo sourceNameField;
    protected Button overwriteExistingResourcesCheckbox;
    protected Button createContainerStructureButton;
    protected Button createOnlySelectedButton;
    protected Button sourceBrowseButton;
    protected Button selectAllButton;
    protected Button deselectAllButton;
    private boolean entryChanged = false;
    private static final String STORE_SOURCE_NAMES_ID = "WizardFileSystemResourceImportPage1.STORE_SOURCE_NAMES_ID";
    private static final String SELECT_ALL_TITLE = J2EEUIMessages.getResourceString("DataTransfer.selectAll");
    private static final String DESELECT_ALL_TITLE = J2EEUIMessages.getResourceString("DataTransfer.deselectAll");
    private static final String SELECT_SOURCE_MESSAGE = J2EEUIMessages.getResourceString("FileImport.selectSource");
    protected static final String SOURCE_EMPTY_MESSAGE = J2EEUIMessages.getResourceString("FileImport.sourceEmpty");
    private IPath importedClassesPath;
    private ZipFileStructureProvider providerCache;
    ZipFileStructureProvider currentProvider;
    private static final String FILE_IMPORT_MASK = "*.jar;*.zip";
    private List dragAndDropFileNames = null;
    boolean createFullStructure = false;
    private String packageBaseDirName = null;
    private String packageDirStruc = null;

    protected WizardClassesImportPage1(String name, IWorkbench aWorkbench, IStructuredSelection selection) {
        super(name, selection);
    }

    public WizardClassesImportPage1(IWorkbench aWorkbench, IStructuredSelection selection, IPath importedClassesPath, List fileNames) {
        this("fileSystemImportPage1", aWorkbench, selection);
        this.setTitle(J2EEUIMessages.getResourceString("DataTransfer.fileSystemTitle"));
        this.setDescription(J2EEUIMessages.getResourceString("FileImport.importFileSystem"));
        this.setImageDescriptor(J2EEUIPlugin.getDefault().getImageDescriptor("import_class_file_wiz_ban"));
        this.importedClassesPath = importedClassesPath;
        if (fileNames != null && fileNames.size() != 0) {
            this.dragAndDropFileNames = fileNames;
        }
    }

    public void blankPage() {
        if (this.selectionGroup != null) {
            this.selectionGroup.setRoot(null);
        }
        if (this.sourceNameField != null) {
            this.sourceNameField.setText("");
        }
    }

    protected void createFileSelectionGroup(Composite parent) {
        this.selectionGroup = new ResourceTreeAndListGroup(parent, (Object)new FileSystemElement("Dummy", null, true), this.getFolderProvider(), (ILabelProvider)new WorkbenchLabelProvider(), (IStructuredContentProvider)this.getFileProvider(), (ILabelProvider)new WorkbenchLabelProvider(), 0, DialogUtil.inRegularFontMode((Composite)parent));
        ICheckStateListener listener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                WizardClassesImportPage1.this.updateWidgetEnablements();
            }
        };
        WorkbenchViewerSorter sorter = new WorkbenchViewerSorter();
        this.selectionGroup.setTreeSorter((ViewerSorter)sorter);
        this.selectionGroup.setListSorter((ViewerSorter)sorter);
        this.selectionGroup.addCheckStateListener(listener);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        GridData buttonData = new GridData(768);
        button.setLayoutData((Object)buttonData);
        button.setData((Object)new Integer(id));
        button.setText(label);
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        return button;
    }

    protected final void createButtonsGroup(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(272));
        SelectionAdapter listener = new SelectionAdapter(){};
        this.selectAllButton = this.createButton(buttonComposite, 18, SELECT_ALL_TITLE, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardClassesImportPage1.this.setAllSelections(true);
            }
        };
        this.selectAllButton.addSelectionListener((SelectionListener)listener);
        this.deselectAllButton = this.createButton(buttonComposite, 19, DESELECT_ALL_TITLE, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardClassesImportPage1.this.setAllSelections(false);
            }
        };
        this.deselectAllButton.addSelectionListener((SelectionListener)listener);
    }

    public void createControl(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.jst.j2ee.ui.IMPORT_CLASS_WIZARD_PAGE2");
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        composite.setFont(parent.getFont());
        this.createSourceGroup(composite);
        this.createOptionsGroup(composite);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setControl((Control)composite);
        this.validateSourceGroup();
    }

    protected void createOptionsGroup(Composite parent) {
        Composite optionsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        optionsGroup.setLayout((Layout)layout);
        optionsGroup.setLayoutData((Object)new GridData(768));
        this.createOptionsGroupButtons(optionsGroup);
    }

    protected void createOptionsGroupButtons(Composite optionsGroup) {
        this.overwriteExistingResourcesCheckbox = new Button(optionsGroup, 32);
        this.overwriteExistingResourcesCheckbox.setText(J2EEUIMessages.getResourceString("FileImport.overwriteExisting"));
    }

    protected boolean isSetImportFromDir() {
        ClassesImportWizard ciw = (ClassesImportWizard)this.getWizard();
        return ciw.mainPage.isSetImportFromDir();
    }

    public String getClassFileDirectory(String s) {
        int index = s.lastIndexOf(File.separatorChar);
        return s.substring(0, index + 1);
    }

    protected void createRootDirectoryGroup(Composite parent) {
        Composite sourceContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        sourceContainerGroup.setLayout((Layout)layout);
        sourceContainerGroup.setLayoutData((Object)new GridData(768));
        new Label(sourceContainerGroup, 0).setText(this.getSourceLabel());
        this.sourceNameField = new Combo(sourceContainerGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.sourceNameField.setLayoutData((Object)data);
        this.setSourceNameFieldForDragAndDrop();
        this.sourceNameField.addListener(24, (Listener)this);
        this.sourceNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardClassesImportPage1.this.updateFromSourceField();
            }
        });
        this.sourceNameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                WizardClassesImportPage1.this.entryChanged = true;
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.sourceNameField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (WizardClassesImportPage1.this.dragAndDropFileNames != null) {
                    WizardClassesImportPage1.this.sourceNameField.setEnabled(false);
                }
            }

            public void focusLost(FocusEvent e) {
                if (WizardClassesImportPage1.this.entryChanged) {
                    WizardClassesImportPage1.this.entryChanged = false;
                    WizardClassesImportPage1.this.updateFromSourceField();
                }
            }
        });
        this.sourceBrowseButton = new Button(sourceContainerGroup, 8);
        this.sourceBrowseButton.setText(J2EEUIMessages.getResourceString("DataTransfer.browse"));
        this.sourceBrowseButton.addListener(13, (Listener)this);
        this.sourceBrowseButton.setLayoutData((Object)new GridData(256));
        if (this.dragAndDropFileNames != null) {
            this.sourceBrowseButton.setEnabled(false);
        }
    }

    private void setSourceNameFieldForDragAndDrop() {
        if (this.dragAndDropFileNames != null) {
            String fileName = (String)this.dragAndDropFileNames.get(0);
            this.sourceNameField.setText(fileName);
            File f = new File(fileName);
            if (f.isFile() && !ImportUtil.getExtension(f).equals("zip") && !ImportUtil.getExtension(f).equals("jar") && ImportUtil.getExtension(f).equals("class")) {
                this.sourceNameField.setText(this.getClassFileDirectory(fileName));
                PackageNameResolver nameResolver = new PackageNameResolver();
                String qualifiedClassName = nameResolver.getClassName(fileName);
                if (qualifiedClassName != null) {
                    int index = qualifiedClassName.indexOf(46);
                    if (index == -1) {
                        String textToSet = fileName.substring(0, 1 + fileName.lastIndexOf(File.separatorChar));
                        this.sourceNameField.setText(textToSet);
                        return;
                    }
                    String baseDir = qualifiedClassName.substring(0, index);
                    index = qualifiedClassName.lastIndexOf(46);
                    String packageName = qualifiedClassName.substring(0, index);
                    this.packageDirStruc = packageName.replace('.', File.separatorChar);
                    index = fileName.indexOf(baseDir);
                    if (fileName.indexOf(this.packageDirStruc) != -1) {
                        int baseDirLength = baseDir.length();
                        String textToSet = fileName.substring(0, index + baseDirLength);
                        index = packageName.indexOf(46);
                        this.packageBaseDirName = index == -1 ? packageName : packageName.substring(0, index);
                        f = new File(textToSet);
                        if (f.getParent() != null) {
                            f = new File(f.getParent());
                        }
                        textToSet = f.getAbsolutePath();
                        this.sourceNameField.setText(textToSet);
                    }
                }
            }
        }
    }

    private void updateFromSourceField() {
        this.setSourceName(this.sourceNameField.getText());
        this.updateWidgetEnablements();
    }

    protected MinimizedFileSystemElement createRootElement(Object fileSystemObject, IImportStructureProvider provider) {
        boolean isContainer = provider.isFolder(fileSystemObject);
        String elementLabel = provider.getLabel(fileSystemObject);
        MinimizedFileSystemElement dummyParent = new MinimizedFileSystemElement("", null, true);
        dummyParent.setPopulated();
        MinimizedFileSystemElement result = new MinimizedFileSystemElement(elementLabel, dummyParent, isContainer);
        result.setPackageBaseDirName(this.packageBaseDirName);
        result.setFileSystemObject(fileSystemObject);
        result.getFiles(provider);
        return dummyParent;
    }

    protected void createSourceGroup(Composite parent) {
        this.createRootDirectoryGroup(parent);
        this.createFileSelectionGroup(parent);
        this.createButtonsGroup(parent);
    }

    protected void enableButtonGroup(boolean enable) {
        this.selectAllButton.setEnabled(enable);
        this.deselectAllButton.setEnabled(enable);
    }

    protected boolean ensureSourceIsValid() {
        if (this.isSetImportFromDir()) {
            if (this.getSourceDirectory() != null && new File(this.getSourceDirectoryName()).isDirectory()) {
                return true;
            }
            this.displayErrorDialog(WizardClassesImportPage1.getString("FileImport.invalidSource"));
            this.sourceNameField.setFocus();
            return false;
        }
        ZipFile specifiedFile = this.getSpecifiedSourceFile();
        if (specifiedFile == null) {
            this.displayErrorDialog(WizardClassesImportPage1.getString("FileImport.invalidSource"));
            this.sourceNameField.setFocus();
            return false;
        }
        return this.closeZipFile(specifiedFile);
    }

    protected boolean executeImportOperation(ImportOperation op) {
        this.initializeOperation(op);
        if (this.createFullStructure) {
            op.setCreateContainerStructure(true);
        } else {
            op.setCreateContainerStructure(false);
        }
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException());
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)WizardClassesImportPage1.getString("FileImport.importProblems"), null, (IStatus)status);
            return false;
        }
        return true;
    }

    private static String getString(String key) {
        try {
            return J2EEUIMessages.getResourceString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public boolean finish() {
        if (!this.ensureSourceIsValid()) {
            return false;
        }
        this.clearProviderCache();
        this.saveWidgetValues();
        Iterator resourcesEnum = this.getSelectedResources().iterator();
        ArrayList<Object> fileSystemObjects = new ArrayList<Object>();
        while (resourcesEnum.hasNext()) {
            fileSystemObjects.add(((FileSystemElement)resourcesEnum.next()).getFileSystemObject());
        }
        if (fileSystemObjects.size() > 0) {
            if (this.getSourceDirectory() != null) {
                return this.importResources(fileSystemObjects);
            }
            return this.importResourcesFromZip(fileSystemObjects);
        }
        MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)WizardClassesImportPage1.getString("DataTransfer.information"), (String)WizardClassesImportPage1.getString("FileImport.noneSelected"));
        return false;
    }

    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)((Object)o);
                    if (WizardClassesImportPage1.this.currentProvider != null) {
                        return element.getFiles((IImportStructureProvider)WizardClassesImportPage1.this.currentProvider).getChildren((Object)element);
                    }
                    return element.getFiles((IImportStructureProvider)FileSystemStructureProvider.INSTANCE).getChildren((Object)element);
                }
                return new Object[0];
            }

            public Object[] getElements(Object element) {
                Object[] superObjects = super.getElements(element);
                if (WizardClassesImportPage1.this.dragAndDropFileNames != null && WizardClassesImportPage1.this.getSourceDirectory() != null) {
                    MinimizedFileSystemElement anElement = null;
                    int newObjectsIndex = 0;
                    int i = 0;
                    while (i < superObjects.length) {
                        anElement = (MinimizedFileSystemElement)((Object)superObjects[i]);
                        File file = (File)anElement.getFileSystemObject();
                        int k = 0;
                        while (k < WizardClassesImportPage1.this.dragAndDropFileNames.size()) {
                            if (file.getAbsolutePath().equals(WizardClassesImportPage1.this.dragAndDropFileNames.get(k))) {
                                ++newObjectsIndex;
                            }
                            ++k;
                        }
                        ++i;
                    }
                    if (newObjectsIndex > 0) {
                        Object[] newObjects = new Object[newObjectsIndex];
                        newObjectsIndex = 0;
                        int i2 = 0;
                        while (i2 < superObjects.length) {
                            anElement = (MinimizedFileSystemElement)((Object)superObjects[i2]);
                            File file = (File)anElement.getFileSystemObject();
                            int k = 0;
                            while (k < WizardClassesImportPage1.this.dragAndDropFileNames.size()) {
                                if (file.getAbsolutePath().equals(WizardClassesImportPage1.this.dragAndDropFileNames.get(k))) {
                                    newObjects[newObjectsIndex++] = anElement;
                                }
                                ++k;
                            }
                            ++i2;
                        }
                        return newObjects;
                    }
                }
                return superObjects;
            }
        };
    }

    protected MinimizedFileSystemElement getFileSystemTree() {
        ZipFileStructureProvider provider;
        if (this.isSetImportFromDir()) {
            File sourceDirectory = this.getSourceDirectory();
            if (sourceDirectory != null) {
                return this.selectFiles(sourceDirectory, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE);
            }
            if (this.sourceNameField.getText().length() > 0) {
                this.displayErrorDialog(WizardClassesImportPage1.getString("FileImport.invalidSource"));
                this.sourceNameField.setFocus();
            }
            return null;
        }
        ZipFile sourceFile = this.getSpecifiedSourceFile();
        if (sourceFile == null) {
            this.currentProvider = null;
            if (this.sourceNameField.getText().length() > 0) {
                this.displayErrorDialog(WizardClassesImportPage1.getString("FileImport.invalidSource"));
                this.sourceNameField.setFocus();
            }
            return null;
        }
        this.currentProvider = provider = this.getStructureProvider(sourceFile);
        return this.selectFiles(provider.getRoot(), (IImportStructureProvider)provider);
    }

    protected ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)((Object)o);
                    if (WizardClassesImportPage1.this.currentProvider != null) {
                        return element.getFolders((IImportStructureProvider)WizardClassesImportPage1.this.currentProvider).getChildren((Object)element);
                    }
                    return element.getFolders((IImportStructureProvider)FileSystemStructureProvider.INSTANCE).getChildren((Object)element);
                }
                return new Object[0];
            }

            public boolean hasChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)((Object)o);
                    if (element.isPopulated()) {
                        return this.getChildren((Object)element).length > 0;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    protected File getSourceDirectory() {
        return this.getSourceDirectory(this.sourceNameField.getText());
    }

    private File getSourceDirectory(String path) {
        if (this.isSetImportFromDir()) {
            File sourceDirectory = new File(this.getSourceDirectoryName(path));
            if (!sourceDirectory.exists() || !sourceDirectory.isDirectory()) {
                return null;
            }
            return sourceDirectory;
        }
        return null;
    }

    private String getSourceDirectoryName() {
        return this.getSourceDirectoryName(this.sourceNameField.getText());
    }

    private String getSourceDirectoryName(String sourceName) {
        Path result = new Path(sourceName.trim());
        result = result.getDevice() != null && result.segmentCount() == 0 ? result.addTrailingSeparator() : result.removeTrailingSeparator();
        return result.toOSString();
    }

    protected String getSourceLabel() {
        return J2EEUIMessages.getResourceString("DataTransfer.directory");
    }

    public void handleEvent(Event event) {
        if (event.widget == this.sourceBrowseButton) {
            if (this.isSetImportFromDir()) {
                this.handleSourceBrowseButtonPressed();
            } else {
                this.handleSourceBrowseButtonPressedForZip();
            }
        }
        super.handleEvent(event);
    }

    protected void handleSourceBrowseButtonPressed() {
        String currentSource = this.sourceNameField.getText();
        DirectoryDialog dialog = new DirectoryDialog(this.sourceNameField.getShell(), 8192);
        dialog.setMessage(SELECT_SOURCE_MESSAGE);
        dialog.setFilterPath(this.getSourceDirectoryName(currentSource));
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            if (this.getSourceDirectory(selectedDirectory) == null || selectedDirectory.equals(currentSource)) {
                return;
            }
            this.setErrorMessage(null);
            this.setSourceName(selectedDirectory);
            this.selectionGroup.setFocus();
        }
    }

    protected void handleTypesEditButtonPressed() {
        super.handleTypesEditButtonPressed();
    }

    protected boolean importResources(List fileSystemObjects) {
        Iterator i = fileSystemObjects.iterator();
        while (i.hasNext()) {
            File f = (File)i.next();
            ArrayList<File> singleItemList = new ArrayList<File>();
            singleItemList.add(f);
            String textToSet = this.getPackageName(f);
            if (textToSet != null) {
                File newSource = new File(textToSet);
                this.executeImportOperation(new ImportOperation(this.getContainerFullPath(), (Object)newSource, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, (IOverwriteQuery)this, singleItemList));
                continue;
            }
            this.executeImportOperation(new ImportOperation(this.getContainerFullPath(), (Object)this.getSourceDirectory(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, (IOverwriteQuery)this, singleItemList));
        }
        return true;
    }

    protected String getPackageName(File f) {
        String fileName;
        PackageNameResolver nameResolver;
        String qualifiedClassName;
        if (ImportUtil.getExtension(f).equals("class") && (qualifiedClassName = (nameResolver = new PackageNameResolver()).getClassName(fileName = f.getAbsolutePath())) != null) {
            int index = qualifiedClassName.indexOf(46);
            if (index == -1) {
                return fileName.substring(0, 1 + fileName.lastIndexOf(File.separatorChar));
            }
            String baseDir = qualifiedClassName.substring(0, index);
            index = qualifiedClassName.lastIndexOf(46);
            String packageName = qualifiedClassName.substring(0, index);
            this.packageDirStruc = packageName.replace('.', File.separatorChar);
            index = fileName.indexOf(baseDir);
            if (fileName.indexOf(this.packageDirStruc) != -1) {
                int baseDirLength = baseDir.length();
                String textToSet = fileName.substring(0, index + baseDirLength);
                index = packageName.indexOf(46);
                this.packageBaseDirName = index == -1 ? packageName : packageName.substring(0, index);
                f = new File(textToSet);
                if (f.getParent() != null) {
                    f = new File(f.getParent());
                }
                textToSet = f.getAbsolutePath();
                return textToSet;
            }
        }
        return null;
    }

    protected void initializeOperation(ImportOperation op) {
        op.setOverwriteResources(this.overwriteExistingResourcesCheckbox.getSelection());
    }

    protected boolean isExportableExtension(String extension) {
        if (this.selectedTypes == null) {
            return true;
        }
        Iterator aenum = this.selectedTypes.iterator();
        while (aenum.hasNext()) {
            if (!extension.equalsIgnoreCase((String)aenum.next())) continue;
            return true;
        }
        return false;
    }

    protected void resetSelection() {
        MinimizedFileSystemElement currentRoot = this.getFileSystemTree();
        this.selectionGroup.setRoot((Object)currentRoot);
        if (this.dragAndDropFileNames != null) {
            if (!this.dragAndDropFileNames.get(0).toString().endsWith(".zip") && !this.dragAndDropFileNames.get(0).toString().endsWith(".jar")) {
                this.selectionGroup.expandAll();
            }
            MinimizedFileSystemElement temp = (MinimizedFileSystemElement)((Object)currentRoot.getFolders().getChildren()[0]);
            List dirList = this.pathToArray();
            int i = 0;
            while (i < dirList.size()) {
                String s = (String)dirList.get(i);
                Object[] folders = temp.getFolders().getChildren();
                int k = 0;
                while (k < folders.length) {
                    if (((File)((MinimizedFileSystemElement)((Object)folders[k])).getFileSystemObject()).getName().equals(s)) {
                        temp = (MinimizedFileSystemElement)((Object)temp.getFolders().getChildren()[k]);
                        break;
                    }
                    ++k;
                }
                ++i;
            }
            if (!this.dragAndDropFileNames.get(0).toString().endsWith(".zip") && !this.dragAndDropFileNames.get(0).toString().endsWith(".jar")) {
                this.selectionGroup.initialCheckTreeItem((Object)temp);
            }
        }
    }

    private List pathToArray() {
        String s = (String)this.dragAndDropFileNames.get(0);
        PackageNameResolver nameResolver = new PackageNameResolver();
        String qualifiedClassName = nameResolver.getClassName(s);
        int slashCounts = 0;
        if (qualifiedClassName != null) {
            int index = qualifiedClassName.indexOf(46);
            if (index == -1) {
                return Collections.EMPTY_LIST;
            }
            String baseDir = qualifiedClassName.substring(0, index);
            int i = s.indexOf(baseDir);
            while (i < s.lastIndexOf(File.separatorChar)) {
                if (s.charAt(i) == File.separatorChar) {
                    ++slashCounts;
                }
                ++i;
            }
        }
        ArrayList<String> dirNamesArray = new ArrayList<String>(slashCounts);
        if (s.endsWith(".zip") || s.endsWith(".jar")) {
            return dirNamesArray;
        }
        int startIndex = 0;
        int i = 0;
        while (i <= slashCounts) {
            int endIndex = qualifiedClassName.indexOf(46, startIndex);
            dirNamesArray.add(qualifiedClassName.substring(startIndex, endIndex));
            startIndex = endIndex + 1;
            ++i;
        }
        return dirNamesArray;
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                return;
            }
            int i = 0;
            while (i < sourceNames.length) {
                this.sourceNameField.add(sourceNames[i]);
                ++i;
            }
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = this.addToHistory(sourceNames, this.getSourceDirectoryName());
            settings.put(STORE_SOURCE_NAMES_ID, sourceNames);
        }
    }

    protected MinimizedFileSystemElement selectFiles(final Object rootFileSystemObject, final IImportStructureProvider structureProvider) {
        final MinimizedFileSystemElement[] results = new MinimizedFileSystemElement[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                results[0] = WizardClassesImportPage1.this.createRootElement(rootFileSystemObject, structureProvider);
            }
        });
        return results[0];
    }

    protected void setAllSelections(boolean value) {
        super.setAllSelections(value);
    }

    protected void setSourceName(String path) {
        if (path.length() > 0) {
            String[] currentItems = this.sourceNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                this.sourceNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.sourceNameField.select(selectionIndex);
            this.resetSelection();
        }
    }

    protected void setupSelectionsBasedOnSelectedTypes() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getContainer().getShell());
        final Hashtable selectionMap = new Hashtable();
        final IElementFilter filter = new IElementFilter(){

            public void filterElements(Collection files, IProgressMonitor monitor) throws InterruptedException {
                if (files == null) {
                    throw new InterruptedException();
                }
                Iterator filesList = files.iterator();
                while (filesList.hasNext()) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    this.checkFile(filesList.next());
                }
            }

            public void filterElements(Object[] files, IProgressMonitor monitor) throws InterruptedException {
                if (files == null) {
                    throw new InterruptedException();
                }
                int i = 0;
                while (i < files.length) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    this.checkFile(files[i]);
                    ++i;
                }
            }

            private void checkFile(Object fileElement) {
                MinimizedFileSystemElement file = (MinimizedFileSystemElement)((Object)fileElement);
                if (WizardClassesImportPage1.this.isExportableExtension(file.getFileNameExtension())) {
                    List<MinimizedFileSystemElement> elements = new ArrayList<MinimizedFileSystemElement>();
                    FileSystemElement parent = file.getParent();
                    if (selectionMap.containsKey(parent)) {
                        elements = (List)selectionMap.get(parent);
                    }
                    elements.add(file);
                    selectionMap.put(parent, elements);
                }
            }
        };
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException {
                monitor.beginTask("ImportPage.filterSelections", -1);
                WizardClassesImportPage1.this.getSelectedResources(filter, monitor);
            }
        };
        try {
            dialog.run(true, true, runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.getShell().update();
        if (selectionMap != null) {
            this.updateSelections(selectionMap);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.resetSelection();
        if (visible) {
            this.sourceNameField.setFocus();
        }
    }

    protected void updateSelections(Map map) {
        super.updateSelections(map);
    }

    protected void updateWidgetEnablements() {
        super.updateWidgetEnablements();
    }

    protected boolean validateSourceGroup() {
        if (this.getSourceDirectory() != null) {
            File sourceDirectory = this.getSourceDirectory();
            if (sourceDirectory == null) {
                this.setMessage(SOURCE_EMPTY_MESSAGE);
                this.enableButtonGroup(false);
                return false;
            }
            if (this.sourceConflictsWithDestination((IPath)new Path(sourceDirectory.getPath()))) {
                this.setErrorMessage(this.getSourceConflictMessage());
                this.enableButtonGroup(false);
                return false;
            }
            this.enableButtonGroup(true);
            return true;
        }
        if (this.currentProvider == null) {
            this.setMessage(SOURCE_EMPTY_MESSAGE);
            this.enableButtonGroup(false);
            return false;
        }
        this.enableButtonGroup(true);
        return true;
    }

    protected boolean sourceConflictsWithDestination(IPath sourcePath) {
        IContainer container = this.getSpecifiedContainer();
        if (container == null) {
            return false;
        }
        return this.getSpecifiedContainer().getLocation().isPrefixOf(sourcePath);
    }

    protected IPath getResourcePath() {
        return this.importedClassesPath;
    }

    public boolean cancel() {
        this.clearProviderCache();
        return true;
    }

    protected void clearProviderCache() {
        if (this.providerCache != null) {
            this.closeZipFile(this.providerCache.getZipFile());
            this.providerCache = null;
        }
    }

    protected boolean closeZipFile(ZipFile file) {
        try {
            file.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    protected ZipFile getSpecifiedSourceFile() {
        return this.getSpecifiedSourceFile(this.sourceNameField.getText());
    }

    private ZipFile getSpecifiedSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new ZipFile(fileName);
        }
        catch (ZipException zipException) {
        }
        catch (IOException iOException) {}
        this.sourceNameField.setFocus();
        return null;
    }

    protected ZipFileStructureProvider getStructureProvider(ZipFile targetZip) {
        if (this.providerCache == null) {
            this.providerCache = new ZipFileStructureProvider(targetZip);
        } else if (!this.providerCache.getZipFile().getName().equals(targetZip.getName())) {
            this.clearProviderCache();
            this.providerCache = new ZipFileStructureProvider(targetZip);
        } else if (!this.providerCache.getZipFile().equals(targetZip)) {
            this.closeZipFile(targetZip);
        }
        return this.providerCache;
    }

    protected void handleSourceBrowseButtonPressedForZip() {
        ZipFile sourceFile;
        String selectedFile = this.queryZipFileToImport();
        if (selectedFile != null && !selectedFile.equals(this.sourceNameField.getText()) && (sourceFile = this.getSpecifiedSourceFile(selectedFile)) != null) {
            this.closeZipFile(sourceFile);
            this.setSourceName(selectedFile);
            this.selectionGroup.setFocus();
        }
    }

    protected boolean importResourcesFromZip(List fileSystemObjects) {
        ZipFile zipFile = this.getSpecifiedSourceFile();
        ZipFileStructureProvider structureProvider = this.getStructureProvider(zipFile);
        boolean result = this.executeImportOperation(new ImportOperation(this.getContainerFullPath(), (Object)structureProvider.getRoot(), (IImportStructureProvider)structureProvider, (IOverwriteQuery)this, fileSystemObjects));
        this.closeZipFile(zipFile);
        return result;
    }

    protected String queryZipFileToImport() {
        FileDialog dialog = new FileDialog(this.sourceNameField.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{FILE_IMPORT_MASK});
        String currentSourceString = this.sourceNameField.getText();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
        }
        return dialog.open();
    }
}

