/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.palette;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.snippets.internal.SnippetDefinitions;
import org.eclipse.wst.common.snippets.internal.palette.ModelFactoryForUser;
import org.eclipse.wst.common.snippets.internal.util.DocumentProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModelFactoryForWorkspace
extends ModelFactoryForUser {
    private static ModelFactoryForWorkspace instance = null;

    public static ModelFactoryForWorkspace getWorkspaceInstance() {
        if (instance == null) {
            instance = new ModelFactoryForWorkspace();
        }
        return instance;
    }

    public SnippetDefinitions loadCurrent() {
        return null;
    }

    protected void loadDefinitions(SnippetDefinitions definitions, Node library) {
        NodeList children = library.getChildNodes();
        int length = children.getLength();
        Node child = null;
        int i = 0;
        while (i < length) {
            child = children.item(i);
            if (child.getNodeType() == 1) {
                if (child.getNodeName().equals("item")) {
                    this.addChild(definitions, (Element)child);
                } else if (child.getNodeName().equals("category")) {
                    this.addCategory(definitions, (Element)child);
                }
            }
            ++i;
        }
    }

    public SnippetDefinitions loadFrom(IFile input) {
        SnippetDefinitions definitions = new SnippetDefinitions();
        DocumentProvider provider = new DocumentProvider();
        Document document = null;
        try {
            provider.setInputStream(input.getContents());
            document = provider.getDocument();
        }
        catch (CoreException coreException) {
            document = null;
        }
        if (document == null) {
            return definitions;
        }
        Element library = document.getDocumentElement();
        if (library == null || !library.getNodeName().equals("snippets")) {
            return definitions;
        }
        this.loadDefinitions(definitions, library);
        this.connectItemsAndCategories(definitions);
        return definitions;
    }
}

