/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.actions;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.jface.action.Action;
import org.eclipse.wst.common.snippets.internal.ISnippetCategory;
import org.eclipse.wst.common.snippets.internal.provisional.ISnippetItem;

public abstract class AbstractItemAction
extends Action {
    private PaletteEntry fEntry = null;
    private GraphicalViewer fViewer = null;

    public AbstractItemAction(GraphicalViewer viewer, PaletteEntry entry) {
        this.fEntry = entry;
        this.fViewer = viewer;
    }

    protected AbstractItemAction(String text) {
        super(text);
    }

    public AbstractItemAction(String text, GraphicalViewer viewer, PaletteEntry entry) {
        super(text);
        this.fEntry = entry;
        this.fViewer = viewer;
    }

    public PaletteEntry getEntry() {
        return this.fEntry;
    }

    public GraphicalViewer getViewer() {
        return this.fViewer;
    }

    protected void refresh(ISnippetCategory category) {
        EditPart part = (EditPart)this.fViewer.getEditPartRegistry().get(category);
        if (part != null) {
            part.refresh();
        }
    }

    protected void refresh(ISnippetItem item) {
        EditPart part = (EditPart)this.fViewer.getEditPartRegistry().get(item);
        if (part != null) {
            part.refresh();
        }
    }

    protected void refresh(PaletteEntry entry) {
        if (entry instanceof ISnippetCategory) {
            this.refresh((ISnippetCategory)entry);
        } else if (entry instanceof ISnippetItem) {
            this.refresh((ISnippetItem)entry);
        }
    }

    public void setEntry(PaletteEntry entry) {
        this.fEntry = entry;
    }

    public void setViewer(GraphicalViewer viewer) {
        this.fViewer = viewer;
    }
}

