/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ValidationConfiguration;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;
import org.eclipse.wst.validation.internal.ui.ResourceHandler;
import org.eclipse.wst.validation.internal.ui.plugin.ValidationUIPlugin;

public class ValidationPropertiesPage
extends PropertyPage {
    static final String NEWLINE = System.getProperty("line.separator");
    static final String TAB = "\t";
    static final String NEWLINE_AND_TAB = String.valueOf(NEWLINE) + "\t";
    private IValidationPage _pageImpl = null;

    protected Control createContents(Composite parent) {
        IProject project = this.getProject();
        if (project == null || !project.isOpen()) {
            this._pageImpl = new InvalidPage(parent);
        } else {
            try {
                this._pageImpl = ConfigurationManager.getManager().getProjectConfiguration(project).numberOfValidators() == 0 ? new NoValidatorsPage(parent) : new ValidatorListPage(parent);
            }
            catch (InvocationTargetException exc) {
                this._pageImpl = new InvalidPage(parent);
                this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
            }
            catch (Throwable exc) {
                this._pageImpl = new InvalidPage(parent);
                this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
            }
        }
        return this._pageImpl.getControl();
    }

    public void dispose() {
        super.dispose();
        try {
            this._pageImpl.dispose();
        }
        catch (Throwable exc) {
            this.logError(exc);
        }
    }

    public IProject getProject() {
        IAdaptable element = this.getElement();
        if (element == null) {
            return null;
        }
        if (element instanceof IProject) {
            return (IProject)element;
        }
        return null;
    }

    protected void noDefaultAndApplyButton() {
        super.noDefaultAndApplyButton();
    }

    protected void performDefaults() {
        super.performDefaults();
        try {
            this._pageImpl.performDefaults();
        }
        catch (InvocationTargetException exc) {
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
        }
        catch (Throwable exc) {
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
        }
    }

    public boolean performOk() {
        try {
            return this._pageImpl.performOk();
        }
        catch (InvocationTargetException exc) {
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
            return false;
        }
        catch (Throwable exc) {
            this.displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
            return false;
        }
    }

    void logError(Throwable exc) {
        Logger logger = WTPUIPlugin.getLogger();
        if (logger.isLoggingLevel(Level.SEVERE)) {
            LogEntry entry = ValidationUIPlugin.getLogEntry();
            entry.setSourceIdentifier("ValidationPropertiesPage.displayAndLogError");
            entry.setMessageTypeIdentifier("VBF_EXC_INTERNAL_PAGE");
            entry.setTargetException(exc);
            logger.write(Level.SEVERE, (Object)entry);
            if (exc instanceof InvocationTargetException && ((InvocationTargetException)exc).getTargetException() != null) {
                entry.setTargetException(((InvocationTargetException)exc).getTargetException());
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    void displayAndLogError(String title, String message, Throwable exc) {
        this.logError(exc);
        this.displayMessage(title, message, 1);
    }

    private void displayMessage(String title, String message, int iIconType) {
        MessageBox messageBox = new MessageBox(this.getShell(), 0x20 | iIconType | 0x10000);
        messageBox.setMessage(message);
        messageBox.setText(title);
        messageBox.open();
    }

    protected Button getDefaultsButton() {
        return super.getDefaultsButton();
    }

    public static interface IValidationPage {
        public Composite createPage(Composite var1) throws InvocationTargetException;

        public boolean performOk() throws InvocationTargetException;

        public boolean performDefaults() throws InvocationTargetException;

        public Composite getControl();

        public void dispose();
    }

    public class InvalidPage
    implements IValidationPage {
        private Composite page = null;
        private Composite composite = null;
        private GridLayout layout = null;
        private Label messageLabel = null;

        public InvalidPage(Composite parent) {
            this.page = this.createPage(parent);
        }

        public Composite createPage(Composite parent) {
            ValidationPropertiesPage.this.noDefaultAndApplyButton();
            ScrolledComposite sc1 = new ScrolledComposite(parent, 768);
            sc1.setLayoutData((Object)new GridData(1808));
            this.composite = new Composite((Composite)sc1, 0);
            sc1.setContent((Control)this.composite);
            this.layout = new GridLayout();
            this.composite.setLayout((Layout)this.layout);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "org.eclipse.wst.common.frameworks.ui.jvpp0000");
            this.messageLabel = new Label(this.composite, 0);
            this.messageLabel.setText(ResourceHandler.getExternalizedMessage("VBF_EXC_INVALID_REGISTER"));
            this.composite.setSize(this.composite.computeSize(-1, -1));
            return this.composite;
        }

        public boolean performDefaults() {
            return true;
        }

        public boolean performOk() {
            return true;
        }

        public Composite getControl() {
            return this.page;
        }

        public void dispose() {
            this.messageLabel.dispose();
            this.composite.dispose();
        }
    }

    public class NoValidatorsPage
    implements IValidationPage {
        private Composite page = null;
        private Composite composite = null;
        private GridLayout layout = null;
        private GridData data = null;
        private Label messageLabel = null;

        public NoValidatorsPage(Composite parent) {
            this.page = this.createPage(parent);
        }

        public Composite createPage(Composite parent) {
            ValidationPropertiesPage.this.noDefaultAndApplyButton();
            ScrolledComposite sc1 = new ScrolledComposite(parent, 768);
            sc1.setLayoutData((Object)new GridData(1808));
            this.composite = new Composite((Composite)sc1, 0);
            sc1.setContent((Control)this.composite);
            this.layout = new GridLayout();
            this.composite.setLayout((Layout)this.layout);
            this.data = new GridData(272);
            this.composite.setLayoutData((Object)this.data);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "org.eclipse.wst.common.frameworks.ui.jvpp0000");
            this.messageLabel = new Label(this.composite, 0);
            String[] msgParm = new String[]{ValidationPropertiesPage.this.getProject().getName()};
            this.messageLabel.setText(ResourceHandler.getExternalizedMessage("VBF_UI_LBL_NOVALIDATORS_DESC", msgParm));
            this.composite.setSize(this.composite.computeSize(-1, -1));
            return this.composite;
        }

        public boolean performDefaults() {
            return true;
        }

        public boolean performOk() {
            return true;
        }

        public Composite getControl() {
            return this.page;
        }

        public void dispose() {
            this.messageLabel.dispose();
            this.composite.dispose();
        }
    }

    public class ValidatorListPage
    implements IValidationPage {
        Composite page = null;
        GridLayout layout = null;
        GridData data = null;
        Label messageLabel = null;
        CheckboxTableViewer validatorList = null;
        Button overrideGlobalButton = null;
        Button autoButton = null;
        Button valWhenBuildButton = null;
        Button selectAllButton = null;
        Button deselectAllButton = null;
        Label emptyRowPlaceholder = null;
        Text maxValProblemsField = null;
        Label maxValProblemsFieldLabel = null;
        ProjectConfiguration pagePreferences = null;
        private boolean isAutoBuildEnabled = false;
        private boolean isBuilderConfigured = false;
        private boolean canOverride = false;
        private ValidatorMetaData[] oldVmd = null;

        public ValidatorListPage(Composite parent) throws InvocationTargetException {
            ConfigurationManager prefMgr = ConfigurationManager.getManager();
            ValidatorManager vMgr = ValidatorManager.getManager();
            this.pagePreferences = new ProjectConfiguration(prefMgr.getProjectConfiguration(ValidationPropertiesPage.this.getProject()));
            this.canOverride = prefMgr.getGlobalConfiguration().canProjectsOverride();
            this.isAutoBuildEnabled = vMgr.isGlobalAutoBuildEnabled();
            this.isBuilderConfigured = ValidatorManager.doesProjectSupportBuildValidation((IProject)ValidationPropertiesPage.this.getProject());
            this.oldVmd = this.pagePreferences.getEnabledValidators();
            this.createPage(parent);
        }

        public Composite createPage(Composite parent) throws InvocationTargetException {
            ScrolledComposite sc1 = new ScrolledComposite(parent, 768);
            sc1.setLayoutData((Object)new GridData(1808));
            this.page = new Composite((Composite)sc1, 0);
            sc1.setContent((Control)this.page);
            this.page.setLayout((Layout)new GridLayout());
            Composite validatorGroup = new Composite(this.page, 0);
            GridLayout validatorGroupLayout = new GridLayout();
            validatorGroupLayout.numColumns = 2;
            validatorGroup.setLayout((Layout)validatorGroupLayout);
            GridData overrideData = new GridData(768);
            overrideData.horizontalSpan = 2;
            this.overrideGlobalButton = new Button(validatorGroup, 32);
            this.overrideGlobalButton.setLayoutData((Object)overrideData);
            this.overrideGlobalButton.setText(ResourceHandler.getExternalizedMessage("PROP_BUTTON_OVERRIDE", new String[]{ValidationPropertiesPage.this.getProject().getName()}));
            this.overrideGlobalButton.setFocus();
            this.overrideGlobalButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.pagePreferences.setDoesProjectOverride(this.this$1.overrideGlobalButton.getSelection());
                    try {
                        this.this$1.updateWidgets();
                    }
                    catch (InvocationTargetException exc) {
                        ValidatorListPage.access$0(this.this$1).displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                    }
                }
            });
            this.emptyRowPlaceholder = new Label(validatorGroup, 0);
            this.emptyRowPlaceholder.setLayoutData((Object)new GridData());
            GridData valWhenBuildData = new GridData(768);
            valWhenBuildData.horizontalSpan = 2;
            this.valWhenBuildButton = new Button(validatorGroup, 32);
            this.valWhenBuildButton.setLayoutData((Object)valWhenBuildData);
            this.valWhenBuildButton.setText(ResourceHandler.getExternalizedMessage("PROP_BUTTON_FULL", new String[]{ValidationPropertiesPage.this.getProject().getName()}));
            this.valWhenBuildButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.pagePreferences.setBuildValidate(this.this$1.valWhenBuildButton.getSelection());
                    this.this$1.valWhenBuildButton.setFocus();
                }
            });
            GridData valWhenAutoBuildData = new GridData(768);
            valWhenAutoBuildData.horizontalSpan = 2;
            this.autoButton = new Button(validatorGroup, 32);
            this.autoButton.setLayoutData((Object)valWhenAutoBuildData);
            this.autoButton.setText(ResourceHandler.getExternalizedMessage("VBF_UI_LBL_AUTO_VALIDATE", new String[]{ValidationPropertiesPage.this.getProject().getName()}));
            this.autoButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.pagePreferences.setAutoValidate(this.this$1.autoButton.getSelection());
                    this.this$1.autoButton.setFocus();
                }
            });
            GridData listLabelData = new GridData(768);
            listLabelData.horizontalSpan = 2;
            this.messageLabel = new Label(validatorGroup, 0);
            this.messageLabel.setText(ResourceHandler.getExternalizedMessage("VBF_UI_LBL_DESC", new String[]{ValidationPropertiesPage.this.getProject().getName()}));
            this.messageLabel.setLayoutData((Object)listLabelData);
            GridData validatorListData = new GridData(768);
            validatorListData.horizontalSpan = 2;
            this.validatorList = CheckboxTableViewer.newCheckList((Composite)validatorGroup, (int)2048);
            this.validatorList.getTable().setLayoutData((Object)validatorListData);
            this.validatorList.setLabelProvider((IBaseLabelProvider)new ValidationLabelProvider());
            this.validatorList.setContentProvider((IContentProvider)new ValidationContentProvider());
            this.validatorList.setSorter((ViewerSorter)new ValidationViewerSorter());
            this.validatorList.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.pagePreferences.setEnabledValidators(ValidationConfiguration.convertToArray((Object[])this.this$1.validatorList.getCheckedElements()));
                    try {
                        this.this$1.updateWidgets();
                    }
                    catch (InvocationTargetException exc) {
                        ValidatorListPage.access$0(this.this$1).displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                    }
                }
            });
            this.validatorList.setInput((Object)this.pagePreferences.getValidators());
            this.selectAllButton = new Button(validatorGroup, 8);
            GridData selectData = new GridData();
            this.selectAllButton.setLayoutData((Object)selectData);
            this.selectAllButton.setText(ResourceHandler.getExternalizedMessage("PROP_BUTTON_SELECTALL"));
            this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    try {
                        this.this$1.performSelectAll();
                    }
                    catch (InvocationTargetException exc) {
                        ValidatorListPage.access$0(this.this$1).displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                    }
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.selectAllButton, "org.eclipse.wst.common.frameworks.ui.jvpp0000");
            GridData deselectData = new GridData();
            this.deselectAllButton = new Button(validatorGroup, 8);
            this.deselectAllButton.setLayoutData((Object)deselectData);
            this.deselectAllButton.setText(ResourceHandler.getExternalizedMessage("PROP_BUTTON_DESELECTALL"));
            this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    try {
                        this.this$1.performDeselectAll();
                    }
                    catch (InvocationTargetException exc) {
                        ValidatorListPage.access$0(this.this$1).displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                    }
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.deselectAllButton, "org.eclipse.wst.common.frameworks.ui.jvpp0000");
            Composite maxGroup = new Composite(this.page, 0);
            GridLayout maxGroupLayout = new GridLayout();
            maxGroupLayout.numColumns = 2;
            maxGroup.setLayout((Layout)maxGroupLayout);
            GridData maxGroupData = new GridData(256);
            maxGroup.setLayoutData((Object)maxGroupData);
            GridData maxLabel = new GridData();
            this.maxValProblemsFieldLabel = new Label(maxGroup, 0);
            this.maxValProblemsFieldLabel.setLayoutData((Object)maxLabel);
            this.maxValProblemsFieldLabel.setText(ResourceHandler.getExternalizedMessage("PROP_LBL_MAXMSSGS", new String[]{ValidationPropertiesPage.this.getProject().getName()}));
            this.maxValProblemsField = new Text(maxGroup, 2052);
            GridData maxValProblemsData = new GridData(768);
            this.maxValProblemsField.setLayoutData((Object)maxValProblemsData);
            this.maxValProblemsField.addKeyListener(new KeyListener(this){
                final /* synthetic */ ValidatorListPage this$1;
                {
                    this.this$1 = validatorListPage;
                }

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    try {
                        this.this$1.pagePreferences.setMaximumNumberOfMessages(this.this$1.checkInteger());
                    }
                    catch (InvocationTargetException exc) {
                        ValidatorListPage.access$0(this.this$1).displayAndLogError(ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_TITLE"), ResourceHandler.getExternalizedMessage("VBF_EXC_INTERNAL_PAGE"), exc);
                    }
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.maxValProblemsField, "org.eclipse.wst.common.frameworks.ui.jvpp0050");
            validatorGroup.setTabList(new Control[]{this.overrideGlobalButton, this.valWhenBuildButton, this.autoButton, this.validatorList.getTable(), this.selectAllButton, this.deselectAllButton});
            this.updateWidgets();
            this.page.setSize(this.page.computeSize(-1, -1));
            return this.page;
        }

        protected void updateTable() throws InvocationTargetException {
            TableItem[] items = this.validatorList.getTable().getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                ValidatorMetaData vmd = (ValidatorMetaData)item.getData();
                this.validatorList.setChecked((Object)vmd, this.pagePreferences.isEnabled(vmd));
                ++i;
            }
        }

        public boolean performDefaults() throws InvocationTargetException {
            this.pagePreferences.resetToDefault();
            this.updateWidgets();
            this.checkInteger();
            ValidationPropertiesPage.this.getDefaultsButton().setFocus();
            return true;
        }

        public boolean performSelectAll() throws InvocationTargetException {
            this.validatorList.setAllChecked(true);
            this.pagePreferences.setEnabledValidators(ValidationConfiguration.convertToArray((Object[])this.validatorList.getCheckedElements()));
            this.updateWidgets();
            this.selectAllButton.setFocus();
            return true;
        }

        public boolean performDeselectAll() throws InvocationTargetException {
            this.validatorList.setAllChecked(false);
            this.pagePreferences.setEnabledValidators(ValidationConfiguration.convertToArray((Object[])this.validatorList.getCheckedElements()));
            this.updateWidgets();
            this.deselectAllButton.setFocus();
            return true;
        }

        protected int checkInteger() throws InvocationTargetException {
            ProjectConfiguration pc = ConfigurationManager.getManager().getProjectConfiguration(ValidationPropertiesPage.this.getProject());
            String text = this.maxValProblemsField.getText();
            if (text == null) {
                ValidationPropertiesPage.this.setErrorMessage(ResourceHandler.getExternalizedMessage("PROP_ERROR_INT"));
                return pc.getMaximumNumberOfMessages();
            }
            try {
                Integer tempInt = new Integer(text.trim());
                if (tempInt <= 0) {
                    ValidationPropertiesPage.this.setErrorMessage(ResourceHandler.getExternalizedMessage("PROP_ERROR_INT"));
                    return pc.getMaximumNumberOfMessages();
                }
                ValidationPropertiesPage.this.setErrorMessage(null);
                return Integer.valueOf(this.maxValProblemsField.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                ValidationPropertiesPage.this.setErrorMessage(ResourceHandler.getExternalizedMessage("PROP_ERROR_INT"));
                return pc.getMaximumNumberOfMessages();
            }
        }

        void updateWidgets() throws InvocationTargetException {
            boolean overridePreferences = this.canOverride && this.pagePreferences.doesProjectOverride();
            this.overrideGlobalButton.setEnabled(this.canOverride);
            this.overrideGlobalButton.setSelection(overridePreferences);
            this.validatorList.getTable().setEnabled(overridePreferences);
            this.validatorList.setAllGrayed(!overridePreferences);
            this.selectAllButton.setEnabled(overridePreferences);
            this.deselectAllButton.setEnabled(overridePreferences);
            this.maxValProblemsField.setEnabled(overridePreferences);
            this.maxValProblemsField.setText(String.valueOf(this.pagePreferences.getMaximumNumberOfMessages()));
            this.updateTable();
            boolean valEnabled = this.pagePreferences.numberOfEnabledValidators() > 0;
            this.valWhenBuildButton.setEnabled(overridePreferences && valEnabled);
            this.valWhenBuildButton.setSelection(this.pagePreferences.isBuildValidate() && valEnabled && this.isBuilderConfigured);
            boolean incValEnabled = this.pagePreferences.numberOfEnabledIncrementalValidators() > 0;
            this.autoButton.setEnabled(overridePreferences && this.isAutoBuildEnabled && incValEnabled);
            this.autoButton.setSelection(this.pagePreferences.isAutoValidate() && incValEnabled && this.isAutoBuildEnabled && this.isBuilderConfigured);
            this.updateHelp();
        }

        protected void updateHelp() throws InvocationTargetException {
            if (this.autoButton.getEnabled()) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.validatorList.getTable(), "org.eclipse.wst.common.frameworks.ui.jvpp0000");
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.autoButton, "org.eclipse.wst.common.frameworks.ui.jvpp0020");
            } else {
                this.validatorList.getTable().setFocus();
                if (this.pagePreferences.numberOfIncrementalValidators() == 0) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.validatorList.getTable(), "org.eclipse.wst.common.frameworks.ui.jvpp0006");
                } else if (!ValidatorManager.getManager().isGlobalAutoBuildEnabled()) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.validatorList.getTable(), "org.eclipse.wst.common.frameworks.ui.jvpp0004");
                } else {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.validatorList.getTable(), "org.eclipse.wst.common.frameworks.ui.jvpp0005");
                }
            }
            if (this.valWhenBuildButton.getEnabled()) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.valWhenBuildButton, "org.eclipse.wst.common.frameworks.ui.jvpp0040");
            } else {
                this.validatorList.getTable().setFocus();
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.validatorList.getTable(), "org.eclipse.wst.common.frameworks.ui.jvpp0003");
            }
            if (this.overrideGlobalButton.getEnabled()) {
                boolean doesProjectSupportBuildValidation = ValidatorManager.doesProjectSupportBuildValidation((IProject)ValidationPropertiesPage.this.getProject());
                GlobalConfiguration gp = ConfigurationManager.getManager().getGlobalConfiguration();
                boolean isPrefAuto = gp.isAutoValidate();
                boolean isPrefManual = gp.isBuildValidate();
                if (doesProjectSupportBuildValidation) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.overrideGlobalButton, "org.eclipse.wst.common.frameworks.ui.jvpp0030");
                } else if (!doesProjectSupportBuildValidation && isPrefAuto && isPrefManual) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.overrideGlobalButton, "org.eclipse.wst.common.frameworks.ui.jvpp0031");
                } else if (!doesProjectSupportBuildValidation && isPrefAuto) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.overrideGlobalButton, "org.eclipse.wst.common.frameworks.ui.jvpp0032");
                } else if (!doesProjectSupportBuildValidation && isPrefManual) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.overrideGlobalButton, "org.eclipse.wst.common.frameworks.ui.jvpp0033");
                } else if (!(doesProjectSupportBuildValidation || isPrefAuto || isPrefManual)) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.overrideGlobalButton, "org.eclipse.wst.common.frameworks.ui.jvpp0030");
                }
            } else {
                this.validatorList.getTable().setFocus();
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.validatorList.getTable(), "org.eclipse.wst.common.frameworks.ui.jvpp0001");
            }
        }

        private void storeValues() throws InvocationTargetException {
            this.pagePreferences.setDoesProjectOverride(this.overrideGlobalButton.getSelection());
            if (this.pagePreferences.doesProjectOverride()) {
                if (this.valWhenBuildButton.isEnabled()) {
                    this.pagePreferences.setBuildValidate(this.valWhenBuildButton.getSelection());
                }
                if (this.autoButton.isEnabled()) {
                    this.pagePreferences.setAutoValidate(this.autoButton.getSelection());
                }
                this.pagePreferences.setMaximumNumberOfMessages(this.checkInteger());
                this.pagePreferences.setEnabledValidators(ValidationConfiguration.convertToArray((Object[])this.validatorList.getCheckedElements()));
            } else {
                this.pagePreferences.resetToDefault();
            }
            this.pagePreferences.passivate();
        }

        public boolean performOk() throws InvocationTargetException {
            this.addBuilder();
            this.isBuilderConfigured = ValidatorManager.doesProjectSupportBuildValidation((IProject)ValidationPropertiesPage.this.getProject());
            this.storeValues();
            if (this.autoButton.getSelection()) {
                int enabledIncrementalValidators = this.pagePreferences.numberOfEnabledIncrementalValidators();
                int enabledValidators = this.pagePreferences.numberOfEnabledValidators();
                if (enabledValidators != enabledIncrementalValidators) {
                    int iIconType = 2;
                    Display display = Display.getCurrent();
                    Shell shell = display == null ? null : display.getActiveShell();
                    MessageBox messageBox = new MessageBox(shell, 0x20 | iIconType);
                    messageBox.setText(ResourceHandler.getExternalizedMessage("VBF_UI_MSSGBOX_TITLE_NONINC"));
                    ValidatorMetaData[] vmds = this.pagePreferences.getEnabledValidators();
                    StringBuffer buffer = new StringBuffer(NEWLINE_AND_TAB);
                    int i = 0;
                    while (i < vmds.length) {
                        ValidatorMetaData vmd = vmds[i];
                        if (!vmd.isIncremental()) {
                            buffer.append(vmd.getValidatorDisplayName());
                            buffer.append(NEWLINE_AND_TAB);
                        }
                        ++i;
                    }
                    messageBox.setMessage(ResourceHandler.getExternalizedMessage("VBF_UI_AUTO_ON_NONINC", new String[]{buffer.toString()}));
                    messageBox.open();
                }
            }
            if (this.pagePreferences.hasEnabledValidatorsChanged(this.oldVmd, false) || ValidatorManager.getManager().isMessageLimitExceeded((IResource)ValidationPropertiesPage.this.getProject())) {
                ValidatorManager.getManager().updateTaskList(ValidationPropertiesPage.this.getProject());
            }
            return true;
        }

        private void addBuilder() {
            if (this.overrideGlobalButton.getSelection() && (this.autoButton.getSelection() || this.valWhenBuildButton.getSelection())) {
                ValidatorManager.addProjectBuildValidationSupport((IProject)ValidationPropertiesPage.this.getProject());
            }
        }

        public Composite getControl() {
            return this.page;
        }

        public void dispose() {
            this.maxValProblemsField.dispose();
            this.maxValProblemsFieldLabel.dispose();
            this.selectAllButton.dispose();
            this.deselectAllButton.dispose();
            this.autoButton.dispose();
            this.valWhenBuildButton.dispose();
            this.validatorList.getTable().dispose();
            this.messageLabel.dispose();
            this.emptyRowPlaceholder.dispose();
            this.overrideGlobalButton.dispose();
            this.page.dispose();
        }

        static /* synthetic */ ValidationPropertiesPage access$0(ValidatorListPage validatorListPage) {
            return validatorListPage.ValidationPropertiesPage.this;
        }

        public class ValidationContentProvider
        implements IStructuredContentProvider {
            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ValidatorMetaData[]) {
                    return (ValidatorMetaData[])inputElement;
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }

        public class ValidationLabelProvider
        extends LabelProvider {
            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                if (element instanceof ValidatorMetaData) {
                    return ((ValidatorMetaData)element).getValidatorDisplayName();
                }
                return super.getText(element);
            }
        }

        public class ValidationViewerSorter
        extends ViewerSorter {
            public int compare(Viewer viewer, Object e1, Object e2) {
                return super.compare(viewer, e1, e2);
            }
        }
    }
}

