/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.eclipse;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.command.internal.env.eclipse.BaseEclipseEnvironment;
import org.eclipse.wst.command.internal.env.eclipse.EclipseURI;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.uri.RelativeURI;
import org.eclipse.wst.command.internal.provisional.env.core.uri.URI;
import org.eclipse.wst.command.internal.provisional.env.core.uri.URIException;
import org.eclipse.wst.command.internal.provisional.env.core.uri.URIScheme;

public class EclipseScheme
implements URIScheme {
    private BaseEclipseEnvironment environment_;
    private MessageUtils msg_;

    public EclipseScheme(BaseEclipseEnvironment environment) {
        this.environment_ = environment;
        this.msg_ = new MessageUtils("org.eclipse.wst.command.internal.env.common.environment", (Object)this);
    }

    public boolean isHierarchical() {
        return true;
    }

    public boolean isValid(URI uri) {
        boolean result = true;
        if (uri == null) {
            return false;
        }
        try {
            this.getPathFromPlatformURI(uri.toString());
        }
        catch (URIException uRIException) {
            result = false;
        }
        return result;
    }

    public URI newURI(String uri) throws URIException {
        String newURI = null;
        if (uri.startsWith("platform:/resource")) {
            newURI = uri;
        } else {
            if (uri.indexOf(":") != -1) {
                throw new URIException((Status)new SimpleStatus("EclipseScheme", this.msg_.getMessage("MSG_INVALID_PLATFORM_URL", new Object[]{uri}), 4));
            }
            if (uri.startsWith("/")) {
                newURI = "platform:/resource" + uri;
            }
        }
        if (newURI == null) {
            return new RelativeURI(uri);
        }
        return new EclipseURI(newURI, this.environment_);
    }

    public URI newURI(URI uri) throws URIException {
        return this.newURI(uri.toString());
    }

    public URI newURI(URL url) throws URIException {
        return this.newURI(url.toString());
    }

    public Status validate(URI uri) {
        Status status = null;
        try {
            this.getPathFromPlatformURI(uri.toString());
            status = new SimpleStatus("");
        }
        catch (URIException exc) {
            status = exc.getStatus();
        }
        return status;
    }

    public String getPathFromPlatformURI(String uri) throws URIException {
        String resourceFile = null;
        URL url = null;
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException malformedURLException) {}
        if (url == null) {
            throw new URIException((Status)new SimpleStatus("EclipseScheme", this.msg_.getMessage("MSG_INVALID_PLATFORM_URL", new Object[]{uri}), 4));
        }
        if (url.getProtocol().equals("platform")) {
            String resourceURL = url.getFile();
            if (resourceURL.startsWith("/resource")) {
                resourceFile = resourceURL.substring(10);
            }
        } else {
            throw new URIException((Status)new SimpleStatus("EclipseScheme", this.msg_.getMessage("MSG_INVALID_PLATFORM_URL", new Object[]{url.getFile()}), 4));
        }
        return resourceFile;
    }

    public String getURLFromPath(IPath absolutePath) {
        return "platform:/resource" + absolutePath;
    }
}

