/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.taglib;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wst.server.core.IRuntime;

public class ServerJarsUtil {
    public static final String baseV6 = "com.ibm.ws.ast.st.runtime.v60";

    public static IPath[] getServerJars(IProject project) {
        IPath[] ret = new IPath[]{};
        IJavaProject javaProject = null;
        try {
            javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
            ArrayList<IPath> list = new ArrayList<IPath>();
            IClasspathEntry[] cp = javaProject.getRawClasspath();
            int size = cp.length;
            int i = 0;
            while (i < size) {
                if (cp[i].getPath().segment(0).equals("org.eclipse.jst.server.core.container")) {
                    IClasspathContainer classpathContainer = JavaCore.getClasspathContainer((IPath)cp[i].getPath(), (IJavaProject)javaProject);
                    int j = 0;
                    while (j < classpathContainer.getClasspathEntries().length) {
                        IClasspathEntry entry = classpathContainer.getClasspathEntries()[j];
                        if (entry.getEntryKind() == 1) {
                            list.add(entry.getPath());
                        }
                        ++j;
                    }
                }
                ++i;
            }
            ret = list.toArray(new IPath[list.size()]);
        }
        catch (Exception exception) {}
        return ret;
    }

    public static boolean isTargetedAtWASV6(IRuntime serverTarget) {
        boolean allowed = false;
        String id = ServerJarsUtil.getServerId(serverTarget);
        if (id != null && serverTarget != null && baseV6.equals(id)) {
            allowed = true;
        }
        return allowed;
    }

    private static String getServerId(IRuntime serverTarget) {
        String id = null;
        if (serverTarget != null && serverTarget.getRuntimeType() != null) {
            id = serverTarget.getRuntimeType().getId();
        }
        return id;
    }
}

