/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.locator;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.j2ee.internal.web.locator.AbstractWebTaglibLocator;
import org.eclipse.jst.j2ee.internal.web.operations.ServerTargetUtil;
import org.eclipse.jst.j2ee.internal.web.taglib.ITaglibInfo;
import org.eclipse.jst.j2ee.internal.web.taglib.ServerJarsUtil;
import org.eclipse.jst.j2ee.internal.web.taglib.TLDDigester;
import org.eclipse.jst.j2ee.internal.web.taglib.TaglibInfo;
import org.eclipse.wst.server.core.IRuntime;

public class WebProjectServerTargetTaglibLocator
extends AbstractWebTaglibLocator {
    private List serverTaglibs = new ArrayList(2);
    private IRuntime runtime;

    public WebProjectServerTargetTaglibLocator(IProject project) {
        super(project);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ITaglibInfo[] search(IResource resource) {
        IRuntime newRuntime = ServerTargetUtil.getServerTarget(this.project.getName());
        if (this.runtime == newRuntime) return this.serverTaglibs.toArray(new ITaglibInfo[this.serverTaglibs.size()]);
        try {
            block6: {
                try {
                    if (ServerJarsUtil.isTargetedAtWASV6(newRuntime)) {
                        this.serverTaglibs = this.calculateServerTargetTaglibs();
                        break block6;
                    }
                    this.serverTaglibs.clear();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            Object var4_6 = null;
            this.runtime = newRuntime;
            return this.serverTaglibs.toArray(new ITaglibInfo[this.serverTaglibs.size()]);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.runtime = newRuntime;
            throw throwable;
        }
    }

    protected ITaglibInfo[] searchFile(File file) {
        if (this.hasJarExtension(file.getName())) {
            return this.searchJarFile(file);
        }
        return EMPTY_TAGLIBINFO_ARRAY;
    }

    protected ITaglibInfo[] searchFile(IFile file) {
        return null;
    }

    protected List calculateServerTargetTaglibs() {
        IPath[] serverJars = ServerJarsUtil.getServerJars(this.project);
        ArrayList<ITaglibInfo> serverTaglibList = new ArrayList<ITaglibInfo>();
        int i = 0;
        while (i < serverJars.length) {
            IPath path = serverJars[i];
            serverTaglibList.addAll(Arrays.asList(this.searchFile(path.toFile())));
            ++i;
        }
        return serverTaglibList;
    }

    protected ITaglibInfo createTaglibForJar(String uri, IPath jarfile, IPath tldLocation) {
        TaglibInfo info = (TaglibInfo)super.createTaglibForJar(uri, jarfile, tldLocation);
        info.setServerContribution(true);
        return info;
    }

    protected boolean canAddTaglibTld(TLDDigester digester) {
        return false;
    }
}

