/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsil.actions;

import java.util.Hashtable;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.ITransformer;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.actions.AddToFavoritesAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilUddiBusinessElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.perspective.WSILPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.transformer.WSILViewSelectionTransformer;

public class AddBusinessToFavoritesAction
extends AddToFavoritesAction {
    public AddBusinessToFavoritesAction(Controller controller) {
        super(controller);
    }

    public boolean favoriteExists() {
        int nodeID = Integer.parseInt((String)this.propertyTable_.get("nodeId"));
        int viewID = Integer.parseInt((String)this.propertyTable_.get("viewId"));
        this.controller_.getWSILPerspective();
        Node selectedNode = this.nodeManager_.getNode(nodeID);
        WsilElement selectedElement = (WsilElement)selectedNode.getTreeElement();
        Object obj = selectedElement.getAllUDDILinks().getElementWithViewId(viewID).getObject();
        WsilUddiBusinessElement wsilUddiBusinessElement = (WsilUddiBusinessElement)((Object)obj);
        String businessName = wsilUddiBusinessElement.getName();
        String inquiryAPI = wsilUddiBusinessElement.getUDDILinkInquiryAPI();
        String businessKey = wsilUddiBusinessElement.getUDDILinkBusinessKey();
        if (businessName == null) {
            businessName = businessKey;
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("UDDIBusinessName", businessName);
        table.put("UDDIBusinessInquiryAPI", inquiryAPI);
        table.put("UDDIBusinessKey", businessKey);
        return this.favoriteExists(table, "relUDDIBusinessFolderNode");
    }

    public ITransformer[] getTransformers() {
        ITransformer[] parentTransformers = super.getTransformers();
        ITransformer[] transformers = new ITransformer[parentTransformers.length + 1];
        System.arraycopy(parentTransformers, 0, transformers, 0, parentTransformers.length);
        transformers[transformers.length - 1] = new WSILViewSelectionTransformer(this.controller_, "uddiLinks", "viewId", 3);
        return transformers;
    }

    public boolean executeSingleLinkAction() {
        int nodeID = Integer.parseInt((String)this.propertyTable_.get("nodeId"));
        int viewID = Integer.parseInt((String)this.propertyTable_.get("viewId"));
        WSILPerspective wsilPerspective = this.controller_.getWSILPerspective();
        Node selectedNode = this.nodeManager_.getNode(nodeID);
        WsilElement selectedElement = (WsilElement)selectedNode.getTreeElement();
        Object obj = selectedElement.getAllUDDILinks().getElementWithViewId(viewID).getObject();
        WsilUddiBusinessElement wsilUddiBusinessElement = (WsilUddiBusinessElement)((Object)obj);
        String businessName = wsilUddiBusinessElement.getName();
        String inquiryAPI = wsilUddiBusinessElement.getUDDILinkInquiryAPI();
        String businessKey = wsilUddiBusinessElement.getUDDILinkBusinessKey();
        if (businessName == null) {
            businessName = businessKey;
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("UDDIBusinessName", businessName);
        table.put("UDDIBusinessInquiryAPI", inquiryAPI);
        table.put("UDDIBusinessKey", businessKey);
        if (this.isMultipleLinkAction() && this.favoriteExists(table, "relUDDIBusinessFolderNode")) {
            wsilPerspective.getMessageQueue().addMessage(wsilPerspective.getMessage("MSG_ERROR_FAVORITES_ALREADY_EXISTS", businessName));
            return false;
        }
        if (this.addToFavorites(table, "relUDDIBusinessFolderNode")) {
            wsilPerspective.getMessageQueue().addMessage(wsilPerspective.getMessage("MSG_INFO_ADD_TO_FAVORITES_SUCCESSFUL", businessName));
            return true;
        }
        wsilPerspective.getMessageQueue().addMessage(wsilPerspective.getMessage("MSG_ERROR_ADD_TO_FAVORITES", businessName));
        return false;
    }
}

