/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.wsdl.Part;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.util.XMLUtils;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions.InvokeWSDLSOAPOperationAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLBindingElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLOperationElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLServiceElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.WSDLPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.util.SoapHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InvokeWSDLSOAPOperationSourceAction
extends InvokeWSDLSOAPOperationAction {
    private boolean newFileSelected_ = false;
    private boolean saveAsSelected_ = false;
    private static final String DUMMY_WRAPPER_START_TAG = "<dummyWrapper>";
    private static final String DUMMY_WRAPPER_END_TAG = "</dummyWrapper>";

    public InvokeWSDLSOAPOperationSourceAction(Controller controller) {
        super(controller);
    }

    private final void fragmentize(StringBuffer fileContents) throws ParserConfigurationException, SAXException, UnsupportedEncodingException, IOException {
        fileContents.insert(0, DUMMY_WRAPPER_START_TAG).append(DUMMY_WRAPPER_END_TAG);
        Element dummyWrapperElement = XMLUtils.stringToElement(fileContents.toString());
        Vector<Node> partElements = new Vector<Node>();
        NodeList partNodes = dummyWrapperElement.getChildNodes();
        int i = 0;
        while (i < partNodes.getLength()) {
            Node partNode = partNodes.item(i);
            if (partNode instanceof Element) {
                partElements.addElement(partNode);
            }
            ++i;
        }
        Object[] elementArray = new Element[partElements.size()];
        partElements.copyInto(elementArray);
        WSDLOperationElement operElement = (WSDLOperationElement)this.getSelectedNavigatorNode().getTreeElement();
        Iterator it = operElement.getOrderedBodyParts().iterator();
        while (it.hasNext()) {
            Part part = (Part)it.next();
            IXSDFragment fragment = operElement.getFragment(part);
            fragment.setParameterValuesFromInstanceDocuments((Element[])elementArray);
        }
    }

    protected boolean processParsedResults(MultipartFormDataParser parser) throws MultipartFormDataException {
        super.processParsedResults(parser);
        WSDLPerspective wsdlPerspective = this.controller_.getWSDLPerspective();
        WSDLOperationElement operElement = (WSDLOperationElement)this.getSelectedNavigatorNode().getTreeElement();
        wsdlPerspective.getMessageQueue();
        this.newFileSelected_ = false;
        this.saveAsSelected_ = false;
        String submissionAction = parser.getParameter("submissionAction");
        String sourceContents = parser.getParameter("::sourceContent");
        if (sourceContents != null) {
            operElement.setPropertyAsString("propSourceContent", sourceContents);
        }
        if ("submissionActionBrowseFile".equals(submissionAction)) {
            this.newFileSelected_ = true;
            String fileContents = parser.getParameter("selectedFile");
            if (fileContents != null) {
                operElement.setPropertyAsString("propSourceContent", fileContents);
            }
        } else if ("submissionActionSaveAs".equals(submissionAction)) {
            this.saveAsSelected_ = true;
        } else {
            String[] nsDeclarations = parser.getParameterValues("::sourceContentNS");
            if (nsDeclarations != null) {
                operElement.setPropertyAsObject("propSourceContentNS", nsDeclarations);
            }
        }
        return true;
    }

    protected Vector getBodyEntries(Hashtable soapEnvelopeNamespaceTable, WSDLOperationElement operElement, WSDLBindingElement bindingElement, WSDLServiceElement serviceElement) throws ParserConfigurationException, Exception {
        Vector<Node> bodyEntries = new Vector<Node>();
        String[] nsDeclarations = (String[])operElement.getPropertyAsObject("propSourceContentNS");
        int i = 0;
        while (i < nsDeclarations.length) {
            String[] prefix_ns = SoapHelper.decodeNamespaceDeclaration(nsDeclarations[i]);
            if (!soapEnvelopeNamespaceTable.contains(prefix_ns[1])) {
                soapEnvelopeNamespaceTable.put(prefix_ns[1], prefix_ns[0]);
            }
            ++i;
        }
        StringBuffer sourceContent = new StringBuffer(operElement.getPropertyAsString("propSourceContent"));
        sourceContent.insert(0, DUMMY_WRAPPER_START_TAG).append(DUMMY_WRAPPER_END_TAG);
        Element dummyWrapperElement = XMLUtils.stringToElement(sourceContent.toString());
        NodeList nl = dummyWrapperElement.getChildNodes();
        int i2 = 0;
        while (i2 < nl.getLength()) {
            if (nl.item(i2) instanceof Element) {
                bodyEntries.add(nl.item(i2));
            }
            ++i2;
        }
        if (!operElement.isDocumentStyle()) {
            this.addRPCWrapper(bodyEntries, (WSDLElement)serviceElement.getParentElement(), operElement, soapEnvelopeNamespaceTable);
        }
        return bodyEntries;
    }

    public final boolean wasNewFileSelected() {
        return this.newFileSelected_;
    }

    public final boolean wasSaveAsSelected() {
        return this.saveAsSelected_;
    }

    public final String getDefaultSaveAsFileName() {
        WSDLOperationElement operElement = (WSDLOperationElement)this.getSelectedNavigatorNode().getTreeElement();
        return operElement.getOperation().getName() + ".txt";
    }

    public final void writeSourceContent(OutputStream os) {
        WSDLOperationElement operElement = (WSDLOperationElement)this.getSelectedNavigatorNode().getTreeElement();
        PrintWriter pw = new PrintWriter(os);
        pw.println(operElement.getPropertyAsString("propSourceContent"));
        pw.close();
    }
}

