/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel;

import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.AbstractUDDIElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.CategoryModel;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.PublishedItemsElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.QueryParentElement;
import org.eclipse.wst.ws.internal.parser.discovery.NetUtils;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Description;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.response.AuthToken;
import org.uddi4j.transport.TransportException;

public class RegistryElement
extends AbstractUDDIElement {
    private final long AUTH_INFO_TIMEOUT = 3000000L;
    private UDDIProxy proxy_;
    private long authTokenTimestamp_;
    private AuthToken authToken_;
    private String id_;
    private String password_;
    private String inquiryURL_;
    private String publishURL_;
    private String cachedPublishURL_;
    private String registrationURL_;
    private Hashtable userDefinedCategories_;
    private boolean checkForUserDefinedCategories_;
    private String categoriesDirectory_;

    public RegistryElement(UDDIProxy proxy, String inquiryURL, String name, Model model) {
        super(name, model);
        this.proxy_ = proxy;
        this.inquiryURL_ = inquiryURL;
        this.publishURL_ = null;
        this.authTokenTimestamp_ = -1L;
        this.authToken_ = null;
        this.id_ = null;
        this.password_ = null;
        this.cachedPublishURL_ = null;
        this.registrationURL_ = null;
        this.userDefinedCategories_ = null;
        this.checkForUserDefinedCategories_ = false;
        this.categoriesDirectory_ = null;
    }

    public final UDDIProxy getProxy() {
        return this.proxy_;
    }

    public final String getInquiryURL() {
        return this.inquiryURL_;
    }

    public final QueryParentElement getQueryParentElement() {
        return (QueryParentElement)((Object)this.getElements("queriesParent").nextElement());
    }

    public final PublishedItemsElement getPublishedBusinessesElement() {
        return (PublishedItemsElement)((Object)this.getElements("publishedBusinessesParent").nextElement());
    }

    public final PublishedItemsElement getPublishedServicesElement() {
        return (PublishedItemsElement)((Object)this.getElements("publishedServicesParent").nextElement());
    }

    public final PublishedItemsElement getPublishedServiceInterfacesElement() {
        return (PublishedItemsElement)((Object)this.getElements("publishedServiceInterfacesParent").nextElement());
    }

    public final void performLogin(String publishURL, String userId, String password) throws TransportException, UDDIException, MalformedURLException {
        this.publishURL_ = publishURL;
        this.proxy_.setPublishURL(NetUtils.createURL((String)publishURL));
        this.authToken_ = this.proxy_.get_authToken(userId, password);
        this.authTokenTimestamp_ = System.currentTimeMillis();
        this.id_ = userId;
        this.password_ = password;
    }

    public final String getAuthInfoString() {
        if (!this.isLoggedIn()) {
            return null;
        }
        if (System.currentTimeMillis() - this.authTokenTimestamp_ > 3000000L) {
            try {
                this.authToken_ = this.proxy_.get_authToken(this.id_, this.password_);
                this.authTokenTimestamp_ = System.currentTimeMillis();
            }
            catch (Throwable throwable) {}
        }
        return this.authToken_.getAuthInfoString();
    }

    public final boolean isLoggedIn() {
        return this.authToken_ != null;
    }

    public final void setCachedPublishURL(String publishURL) {
        this.cachedPublishURL_ = publishURL;
    }

    public final String getPublishURL() {
        if (this.isLoggedIn() && this.publishURL_ != null) {
            return this.publishURL_;
        }
        return this.cachedPublishURL_;
    }

    public final void setRegistrationURL(String registrationURL) {
        this.registrationURL_ = registrationURL;
    }

    public final String getRegistrationURL() {
        return this.registrationURL_;
    }

    public final String getUserId() {
        return this.id_;
    }

    public final void setUserId(String userId) {
        this.id_ = userId;
    }

    public final String getCred() {
        return this.password_;
    }

    public final void setCred(String cred) {
        this.password_ = cred;
    }

    public final void setUserDefinedCategories(Hashtable userDefinedCategories) {
        this.userDefinedCategories_ = userDefinedCategories;
    }

    public final Enumeration getUserDefinedCategories() {
        if (this.userDefinedCategories_ != null) {
            return this.userDefinedCategories_.elements();
        }
        return null;
    }

    public final CategoryModel getUserDefinedCategory(String tModelKey) {
        return (CategoryModel)((Object)this.userDefinedCategories_.get(tModelKey));
    }

    public final void handlePreInvocation(BusinessService busService) {
        if (this.getInquiryURL().equals("http://uddi.xmethods.net/inquire")) {
            Vector<Description> descriptionVector = busService.getDescriptionVector();
            if (descriptionVector == null) {
                descriptionVector = new Vector<Description>();
            }
            boolean containsImplementationDescription = false;
            int i = 0;
            while (i < descriptionVector.size()) {
                Description description = (Description)descriptionVector.elementAt(i);
                if (description.getText().startsWith("IMPLEMENTATION: ")) {
                    containsImplementationDescription = true;
                    break;
                }
                ++i;
            }
            if (!containsImplementationDescription) {
                descriptionVector.addElement(new Description("IMPLEMENTATION: ibmws"));
                busService.setDescriptionVector(descriptionVector);
            }
        }
    }

    public final void setCheckForUserDefinedCategories(boolean checkForUserDefinedCategories) {
        this.checkForUserDefinedCategories_ = checkForUserDefinedCategories;
    }

    public final boolean getCheckForUserDefinedCategories() {
        return this.checkForUserDefinedCategories_;
    }

    public final void setCategoriesDirectory(String directory) {
        this.categoriesDirectory_ = directory;
    }

    public final String getCategoriesDirectory() {
        return this.categoriesDirectory_;
    }
}

