/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.util.Vector;
import org.eclipse.wst.ws.internal.explorer.platform.actions.FormInputException;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.FindAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.QueryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.transport.TransportException;

public class RegFindBusinessUUIDAction
extends FindAction {
    public RegFindBusinessUUIDAction(Controller controller) {
        super(controller);
        this.propertyTable_.put("queryItem", String.valueOf(0));
        this.propertyTable_.put("queryStyleBusinesses", String.valueOf(2));
    }

    protected final boolean processOthers(MultipartFormDataParser parser, FormToolPropertiesInterface formToolPI) throws MultipartFormDataException {
        String uuidKey = parser.getParameter("uuidKey");
        boolean inputsValid = true;
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        if (uuidKey != null) {
            this.propertyTable_.put("uuidBusinessKey", uuidKey);
        }
        if (!this.subQueryInitiated_ && !Validator.validateString(uuidKey)) {
            inputsValid = false;
            formToolPI.flagError("uuidBusinessKey");
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_UUID_KEY"));
        }
        return inputsValid;
    }

    public final boolean run() {
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        try {
            boolean shouldAddQueryNode = this.propertyTable_.get("overrideAddQueryNode") == null;
            String uuidKey = (String)this.propertyTable_.get("uuidBusinessKey");
            if (this.regNode_ == null) {
                this.regNode_ = this.getRegistryNode((Node)this.propertyTable_.get("refreshNode"));
            }
            RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
            UDDIProxy proxy = regElement.getProxy();
            BusinessEntity[] beList = new BusinessEntity[1];
            Vector beVector = proxy.get_businessDetail(uuidKey).getBusinessEntityVector();
            if (beVector.size() > 0) {
                beVector.toArray(beList);
                if (shouldAddQueryNode) {
                    String queryName = (String)this.propertyTable_.get("queryName");
                    this.queryElement_ = new QueryElement(beList, queryName, regElement.getModel());
                    this.addQueryNode();
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_BUSINESSES_FOUND", String.valueOf(beList.length)));
                }
                this.propertyTable_.put("latestObject", beList[0]);
                return true;
            }
            throw new FormInputException(uddiPerspective.getMessage("MSG_ERROR_NO_BUSINESSES_FOUND"));
        }
        catch (TransportException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("TransportException");
            messageQueue.addMessage(e.getMessage());
        }
        catch (UDDIException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("UDDIException");
            messageQueue.addMessage(e.toString());
        }
        catch (FormInputException e) {
            messageQueue.addMessage(e.getMessage());
        }
        return false;
    }
}

