/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesFolderElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.perspective.FavoritesPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.UDDINodeAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.BusinessElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.CategoryModel;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.ServiceElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.ServiceInterfaceElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.BusinessNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.RegistryNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.ServiceInterfaceNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.ServiceNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;

public class AddToFavoritesAction
extends UDDINodeAction {
    public AddToFavoritesAction(Controller controller) {
        super(controller);
    }

    public static String getActionLink(int nodeId) {
        StringBuffer actionLink = new StringBuffer("uddi/actions/CheckFavoriteExistsActionJSP.jsp?");
        actionLink.append("nodeId").append('=').append(nodeId);
        return actionLink.toString();
    }

    public final boolean registryExists(String registryName, Node registryNode) {
        RegistryElement cfr_ignored_0 = (RegistryElement)registryNode.getTreeElement();
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("UDDIRegistryName", registryName);
        return this.favoriteExists(table, "relUDDIRegistryFolerNode");
    }

    public final boolean businessExists(String businessName, Node businessNode) {
        BusinessElement busElement = (BusinessElement)businessNode.getTreeElement();
        RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
        String businessKey = busElement.getBusinessEntity().getBusinessKey();
        String inquiryURL = regElement.getInquiryURL();
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("UDDIBusinessName", businessName);
        table.put("UDDIBusinessInquiryAPI", inquiryURL);
        table.put("UDDIBusinessKey", businessKey);
        return this.favoriteExists(table, "relUDDIBusinessFolderNode");
    }

    public final boolean serviceExists(String serviceName, Node serviceNode) {
        ServiceElement serviceElement = (ServiceElement)serviceNode.getTreeElement();
        RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
        String serviceKey = serviceElement.getBusinessService().getServiceKey();
        String inquiryURL = regElement.getInquiryURL();
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("UDDIServiceName", serviceName);
        table.put("UDDIServiceInquiryAPI", inquiryURL);
        table.put("UDDIServiceKey", serviceKey);
        return this.favoriteExists(table, "relUDDIServiceFolderNode");
    }

    public final boolean serviceInterfaceExists(String siName, Node siNode) {
        ServiceInterfaceElement siElement = (ServiceInterfaceElement)siNode.getTreeElement();
        RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
        String tModelKey = siElement.getTModel().getTModelKey();
        String inquiryURL = regElement.getInquiryURL();
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("UDDIServiceInterfaceName", siName);
        table.put("UDDIServiceInterfaceInquiryAPI", inquiryURL);
        table.put("UDDIServiceInterfaceKey", tModelKey);
        return this.favoriteExists(table, "relUDDIServiceInterfaceFolderNode");
    }

    public final boolean addRegistryToFavorites(String registryName, Node registryNode) {
        RegistryElement regElement = (RegistryElement)registryNode.getTreeElement();
        String inquiryURL = regElement.getInquiryURL();
        String publishURL = regElement.getPublishURL();
        if (publishURL == null) {
            publishURL = "";
        }
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        table.put("UDDIRegistryPublishAPI", publishURL);
        table.put("UDDIRegistryInquiryAPI", inquiryURL);
        table.put("UDDIRegistryName", registryName);
        Enumeration userDefinedCategoriesEnum = regElement.getUserDefinedCategories();
        if (userDefinedCategoriesEnum != null) {
            table.put("UDDIRegistryCategoriesEnum", userDefinedCategoriesEnum);
            table.put("pluginMetadataDirectory", this.controller_.getServletEngineStateLocation());
        }
        return this.addToFavorites(table, "relUDDIRegistryFolerNode");
    }

    public final boolean addBusinessToFavorites(String businessName, Node businessNode) {
        BusinessElement busElement = (BusinessElement)businessNode.getTreeElement();
        RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
        String businessKey = busElement.getBusinessEntity().getBusinessKey();
        String inquiryURL = regElement.getInquiryURL();
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("UDDIBusinessName", businessName);
        table.put("UDDIBusinessInquiryAPI", inquiryURL);
        table.put("UDDIBusinessKey", businessKey);
        return this.addToFavorites(table, "relUDDIBusinessFolderNode");
    }

    public final boolean addServiceToFavorites(String serviceName, Node serviceNode) {
        ServiceElement serviceElement = (ServiceElement)serviceNode.getTreeElement();
        RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
        String serviceKey = serviceElement.getBusinessService().getServiceKey();
        String inquiryURL = regElement.getInquiryURL();
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("UDDIServiceName", serviceName);
        table.put("UDDIServiceInquiryAPI", inquiryURL);
        table.put("UDDIServiceKey", serviceKey);
        return this.addToFavorites(table, "relUDDIServiceFolderNode");
    }

    public final boolean addServiceInterfaceToFavorites(String siName, Node siNode) {
        ServiceInterfaceElement siElement = (ServiceInterfaceElement)siNode.getTreeElement();
        RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
        String tModelKey = siElement.getTModel().getTModelKey();
        String inquiryURL = regElement.getInquiryURL();
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("UDDIServiceInterfaceName", siName);
        table.put("UDDIServiceInterfaceInquiryAPI", inquiryURL);
        table.put("UDDIServiceInterfaceKey", tModelKey);
        return this.addToFavorites(table, "relUDDIServiceInterfaceFolderNode");
    }

    public boolean favoriteExists() {
        int nodeId = Integer.parseInt((String)this.propertyTable_.get("nodeId"));
        Node node = this.nodeManager_.getNode(nodeId);
        String nodeName = node.getNodeName();
        if (node instanceof RegistryNode) {
            return this.registryExists(nodeName, node);
        }
        if (node instanceof BusinessNode) {
            return this.businessExists(nodeName, node);
        }
        if (node instanceof ServiceNode) {
            return this.serviceExists(nodeName, node);
        }
        if (node instanceof ServiceInterfaceNode) {
            return this.serviceInterfaceExists(nodeName, node);
        }
        return false;
    }

    public boolean run() {
        int nodeId = Integer.parseInt((String)this.propertyTable_.get("nodeId"));
        Node node = this.nodeManager_.getNode(nodeId);
        String nodeName = node.getNodeName();
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        boolean addToFavoritesResult = false;
        if (node instanceof RegistryNode) {
            addToFavoritesResult = this.addRegistryToFavorites(nodeName, node);
            RegistryElement regElement = (RegistryElement)node.getTreeElement();
            Enumeration e = regElement.getUserDefinedCategories();
            if (e != null) {
                while (e.hasMoreElements()) {
                    CategoryModel categoryModel = (CategoryModel)((Object)e.nextElement());
                    Throwable errorException = categoryModel.getErrorException();
                    if (errorException == null) continue;
                    String[] args = new String[]{categoryModel.getDisplayName(), errorException.getMessage()};
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_SAVING_CATEGORY_DATA", args));
                }
            }
        } else if (node instanceof BusinessNode) {
            addToFavoritesResult = this.addBusinessToFavorites(nodeName, node);
        } else if (node instanceof ServiceNode) {
            addToFavoritesResult = this.addServiceToFavorites(nodeName, node);
        } else if (node instanceof ServiceInterfaceNode) {
            addToFavoritesResult = this.addServiceInterfaceToFavorites(nodeName, node);
        }
        if (addToFavoritesResult) {
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_FAVORITE_ADDED", nodeName));
        } else {
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_FAVORITE_NOT_ADDED", nodeName));
        }
        return addToFavoritesResult;
    }

    protected boolean addToFavorites(Hashtable table, String rel) {
        FavoritesPerspective favPerspective = this.controller_.getFavoritesPerspective();
        NodeManager favNodeManager = favPerspective.getNodeManager();
        TreeElement favRootElement = favNodeManager.getRootNode().getTreeElement();
        Enumeration e = favRootElement.getElements(rel);
        if (!e.hasMoreElements()) {
            return false;
        }
        FavoritesFolderElement favFolderElement = (FavoritesFolderElement)((Object)e.nextElement());
        return favFolderElement.addFavorite(table);
    }

    protected boolean favoriteExists(Hashtable table, String rel) {
        FavoritesPerspective favPerspective = this.controller_.getFavoritesPerspective();
        NodeManager favNodeManager = favPerspective.getNodeManager();
        TreeElement favRootElement = favNodeManager.getRootNode().getTreeElement();
        Enumeration e = favRootElement.getElements(rel);
        if (!e.hasMoreElements()) {
            return false;
        }
        FavoritesFolderElement favFolderElement = (FavoritesFolderElement)((Object)e.nextElement());
        return favFolderElement.favoriteExists(table);
    }

    public final String getActionLinkForHistory() {
        return null;
    }
}

