/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java.search;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jst.jsp.core.internal.java.search.JSPPathIndexer;
import org.eclipse.jst.jsp.core.internal.java.search.JSPSearchSupport;
import org.eclipse.jst.jsp.core.internal.java.search.JavaSearchDocumentDelegate;
import org.eclipse.jst.jsp.core.internal.java.search.NullSearchDocument;

public class JSPSearchParticipant
extends SearchParticipant {
    private static final boolean DEBUG = JSPSearchParticipant.calculateValue();

    private static boolean calculateValue() {
        String value = Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jspsearch");
        boolean debug = value != null && value.equalsIgnoreCase("true");
        return debug;
    }

    public SearchDocument getDocument(String documentPath) {
        SearchDocument sDoc = JSPSearchSupport.getInstance().getSearchDocument(documentPath);
        if (sDoc == null) {
            return new NullSearchDocument(documentPath);
        }
        return sDoc;
    }

    public String getDescription() {
        return "JSP";
    }

    public IPath[] selectIndexes(SearchPattern pattern, IJavaSearchScope scope) {
        JSPPathIndexer indexer = new JSPPathIndexer();
        return indexer.getVisibleJspPaths(pattern, scope);
    }

    public void indexDocument(SearchDocument document, IPath indexPath) {
        if (!(document instanceof JavaSearchDocumentDelegate)) {
            return;
        }
        SearchEngine.getDefaultSearchParticipant().indexDocument(document, indexPath);
    }

    public void locateMatches(SearchDocument[] indexMatches, SearchPattern pattern, IJavaSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        ArrayList<SearchDocument> filtered = new ArrayList<SearchDocument>();
        SearchDocument match = null;
        int i = 0;
        while (i < indexMatches.length) {
            if (DEBUG) {
                System.out.println("found possible matching JavaSearchDocumentDelegate: " + indexMatches[i]);
            }
            if ((match = indexMatches[i]) != null && match instanceof JavaSearchDocumentDelegate && ((JavaSearchDocumentDelegate)match).getFile().exists()) {
                filtered.add(match);
            }
            ++i;
        }
        indexMatches = filtered.toArray(new SearchDocument[filtered.size()]);
        SearchEngine.getDefaultSearchParticipant().locateMatches(indexMatches, pattern, scope, requestor, monitor);
    }

    public void beginSearching() {
    }

    public void doneSearching() {
    }

    public SearchDocument getDocument(IFile file) {
        return null;
    }
}

