/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.provisional.env.core.common;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;

public class SimpleStatus
implements Status {
    private List children_ = new LinkedList();
    private String id_;
    private String message_;
    private int severity_;
    private Throwable throwable_;

    public SimpleStatus(String id) {
        this(id, "", 0, null);
    }

    public SimpleStatus(String id, String message, int severity) {
        this(id, message, severity, null);
    }

    public SimpleStatus(String id, String message, Status[] children) {
        this(id, message, 0, null);
        int i = 0;
        while (i < children.length) {
            this.children_.add(children[i]);
            ++i;
        }
    }

    public SimpleStatus(String id, String message, int severity, Throwable throwable) {
        this.id_ = id;
        this.message_ = message;
        this.severity_ = severity;
        this.throwable_ = throwable;
    }

    public String getId() {
        return this.id_;
    }

    public String getMessage() {
        return this.message_;
    }

    public int getSeverity() {
        int severity = this.severity_;
        if (this.children_.size() > 0) {
            Iterator i = this.children_.iterator();
            while (i.hasNext()) {
                Status status = (Status)i.next();
                int childSeverity = status.getSeverity();
                if (childSeverity <= severity) continue;
                severity = childSeverity;
            }
        }
        return severity;
    }

    public Throwable getThrowable() {
        return this.throwable_;
    }

    public boolean hasChildren() {
        return this.children_.size() > 0;
    }

    public Status[] getChildren() {
        return this.children_.toArray(new Status[0]);
    }

    public boolean matches(int mask) {
        return (this.getSeverity() | mask) != 0;
    }

    public void addChild(Status status) {
        this.children_.add(status);
    }
}

