/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.wizard;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.provisional.contenttype.ContentTypeIdForCSS;
import org.eclipse.wst.css.ui.internal.CSSUIMessages;
import org.eclipse.wst.css.ui.internal.Logger;
import org.eclipse.wst.css.ui.internal.image.CSSImageHelper;
import org.eclipse.wst.css.ui.internal.wizard.NewCSSTemplatesWizardPage;

public class NewCSSWizard
extends Wizard
implements INewWizard {
    private WizardNewFileCreationPage fNewFilePage;
    private NewCSSTemplatesWizardPage fNewFileTemplatesPage;
    private IStructuredSelection fSelection;
    private List fValidExtensions = null;

    List getValidExtensions() {
        if (this.fValidExtensions == null) {
            IContentType type = Platform.getContentTypeManager().getContentType(ContentTypeIdForCSS.ContentTypeID_CSS);
            this.fValidExtensions = new ArrayList<String>(Arrays.asList(type.getFileSpecs(8)));
        }
        return this.fValidExtensions;
    }

    public void addPages() {
        this.fNewFilePage = new WizardNewFileCreationPage("CSSWizardNewFileCreationPage", (IStructuredSelection)new StructuredSelection(IDE.computeSelectedResources((IStructuredSelection)this.fSelection))){

            protected boolean validatePage() {
                Path handlePath = new Path(this.getFileName());
                String extension = handlePath.getFileExtension();
                if (extension == null || !extension.equalsIgnoreCase("css")) {
                    this.setErrorMessage(CSSUIMessages._ERROR_FILENAME_MUST_END_CSS);
                    return false;
                }
                this.setErrorMessage(null);
                return super.validatePage();
            }
        };
        this.fNewFilePage.setTitle(CSSUIMessages._UI_WIZARD_NEW_HEADING);
        this.fNewFilePage.setDescription(CSSUIMessages._UI_WIZARD_NEW_DESCRIPTION);
        this.addPage((IWizardPage)this.fNewFilePage);
        this.fNewFileTemplatesPage = new NewCSSTemplatesWizardPage();
        this.addPage((IWizardPage)this.fNewFileTemplatesPage);
    }

    public void init(IWorkbench aWorkbench, IStructuredSelection aSelection) {
        this.fSelection = aSelection;
        this.setWindowTitle(CSSUIMessages._UI_WIZARD_NEW_TITLE);
        ImageDescriptor descriptor = CSSImageHelper.getInstance().getImageDescriptor("icons/full/wizban/newcssfile_wiz.gif");
        this.setDefaultPageImageDescriptor(descriptor);
    }

    private void openEditor(final IFile file) {
        if (file != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException e) {
                        Logger.log(202, e.getMessage(), e);
                    }
                }
            });
        }
    }

    public boolean performFinish() {
        this.fNewFileTemplatesPage.saveLastSavedPreferences();
        IFile file = this.fNewFilePage.createNewFile();
        String templateString = this.fNewFileTemplatesPage.getTemplateString();
        if (templateString != null) {
            Preferences preference = CSSCorePlugin.getDefault().getPluginPreferences();
            String charSet = preference.getString("outputCodeset");
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                OutputStreamWriter outputStreamWriter = null;
                outputStreamWriter = charSet == null || charSet.trim().equals("") ? new OutputStreamWriter(outputStream) : new OutputStreamWriter((OutputStream)outputStream, charSet);
                outputStreamWriter.write(templateString);
                outputStreamWriter.flush();
                outputStreamWriter.close();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                file.setContents((InputStream)inputStream, true, false, null);
                inputStream.close();
            }
            catch (Exception e) {
                Logger.log(202, "Could not create contents for new CSS file", e);
            }
        }
        this.openEditor(file);
        return true;
    }
}

