/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.selection;

import org.eclipse.jface.text.Region;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.ui.internal.CSSUIMessages;
import org.eclipse.wst.css.ui.internal.selection.StructureSelectCSSAction;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.selection.SelectionHistory;
import org.w3c.dom.Node;

public class StructureSelectNextCSSAction
extends StructureSelectCSSAction {
    public StructureSelectNextCSSAction(StructuredTextEditor editor, SelectionHistory history) {
        super(editor, history);
        this.setText(CSSUIMessages.StructureSelectNext_label);
        this.setToolTipText(CSSUIMessages.StructureSelectNext_tooltip);
        this.setDescription(CSSUIMessages.StructureSelectNext_description);
    }

    protected IndexedRegion getCursorIndexedRegion() {
        int offset = this.fViewer.getSelectedRange().x + this.fViewer.getSelectedRange().y - 1;
        if (offset < 0) {
            offset = 0;
        }
        return this.getIndexedRegion(offset);
    }

    protected Region getNewSelectionRegion(Node node, Region region) {
        return null;
    }

    protected Region getNewSelectionRegion(ICSSNode node, Region region) {
        Region newRegion = null;
        ICSSNode newNode = node.getNextSibling();
        if (newNode == null) {
            newNode = node.getParentNode();
            if (newNode instanceof IndexedRegion) {
                IndexedRegion newIndexedRegion = (IndexedRegion)newNode;
                newRegion = new Region(newIndexedRegion.getStartOffset(), newIndexedRegion.getEndOffset() - newIndexedRegion.getStartOffset());
            }
        } else if (newNode instanceof IndexedRegion) {
            IndexedRegion newIndexedRegion = (IndexedRegion)newNode;
            newRegion = new Region(region.getOffset(), newIndexedRegion.getEndOffset() - region.getOffset());
        }
        return newRegion;
    }
}

