/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.data.internal.ui.extract;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.wst.rdb.data.internal.core.extract.ExtractData;
import org.eclipse.wst.rdb.data.internal.ui.FileFormatWizardPage;
import org.eclipse.wst.rdb.data.internal.ui.extract.Messages;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;
import org.eclipse.wst.rdb.internal.outputview.OutputItem;
import org.eclipse.wst.rdb.internal.outputview.OutputViewAPI;

public class ExtractDataWizard
extends Wizard {
    protected Table table;
    protected FileFormatWizardPage page;

    public ExtractDataWizard(Table table) {
        this.table = table;
        this.setWindowTitle(Messages.getString("ExtractDataWizard.ExtractData"));
    }

    public void addPages() {
        this.page = new FileFormatWizardPage("org.eclipse.wst.rdb.data.ui.extractData", true);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.page.saveSettings();
        String colDelim = this.page.getColumnDelimiter();
        String stringDelim = this.page.getStringDelimiter();
        String filePath = this.page.getFilePath();
        final ExtractData extract = new ExtractData(this.table, filePath);
        extract.setDelims(colDelim, stringDelim);
        final OutputItem item = this.initDbOutputItem();
        Job job = new Job(Messages.getString("ExtractDataWizard.DataExtraction")){

            protected IStatus run(IProgressMonitor monitor) {
                int ret = extract.doExtract(item);
                OutputViewAPI.getInstance().updateStatus(item, ret, true);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.schedule();
        return true;
    }

    protected OutputItem initDbOutputItem() {
        OutputItem item = OutputViewAPI.getInstance().findOutputItem(this.getFullyQualifiedName(), 37, true);
        if (item == null) {
            item = new OutputItem(5, 37, this.table.getName(), this.getFullyQualifiedName());
            OutputViewAPI.getInstance().addOutputItem(item, true);
        } else {
            OutputViewAPI.getInstance().resetOutputItem(item, true);
            OutputViewAPI.getInstance().updateStatus(item, 5, true);
        }
        return item;
    }

    protected String getFullyQualifiedName() {
        return "\"" + this.table.getSchema().getName() + "\".\"" + this.table.getName() + "\"";
    }
}

