/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.views.contentoutline;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.wst.common.ui.internal.dnd.DragAndDropManager;
import org.eclipse.wst.common.ui.internal.dnd.ObjectTransfer;
import org.eclipse.wst.common.ui.internal.dnd.ViewerDragAdapter;
import org.eclipse.wst.common.ui.internal.dnd.ViewerDropAdapter;
import org.eclipse.wst.dtd.ui.internal.DTDUIPlugin;
import org.eclipse.wst.dtd.ui.internal.dnd.DTDDragAndDropManager;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.DTDContextMenuHelper;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.DTDLabelProvider;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.DTDTreeContentProvider;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.OrderAction;
import org.eclipse.wst.dtd.ui.internal.views.contentoutline.SortAction;
import org.eclipse.wst.sse.ui.internal.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateAction;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateActionContributionItem;
import org.eclipse.wst.sse.ui.internal.provisional.views.contentoutline.StructuredContentOutlineConfiguration;
import org.eclipse.wst.sse.ui.internal.util.Assert;

public class DTDContentOutlineConfiguration
extends StructuredContentOutlineConfiguration {
    private IContentProvider fContentProvider = null;
    private ILabelProvider fLabelProvider = null;
    private DTDContextMenuHelper fMenuHelper;
    private TransferDragSourceListener[] fTransferDragSourceListeners;
    private TransferDropTargetListener[] fTransferDropTargetListeners;
    private Map fViewerContributions = new HashMap(2);
    private final String OUTLINE_ORDER_PREF = "outline-order";
    private final String OUTLINE_SORT_PREF = "outline-sort";

    public IContributionItem[] createToolbarContributions(TreeViewer viewer) {
        Assert.isTrue((boolean)(this.getContentProvider(viewer) instanceof DTDTreeContentProvider), (String)"invalid content provider on viewer");
        IContributionItem[] items = super.createToolbarContributions(viewer);
        SortAction sortAction = new SortAction(viewer, DTDUIPlugin.getDefault().getPreferenceStore(), "outline-sort");
        OrderAction orderAction = new OrderAction(viewer, (DTDTreeContentProvider)this.getContentProvider(viewer), DTDUIPlugin.getDefault().getPreferenceStore(), "outline-order");
        PropertyChangeUpdateActionContributionItem sortItem = new PropertyChangeUpdateActionContributionItem((PropertyChangeUpdateAction)sortAction);
        PropertyChangeUpdateActionContributionItem orderItem = new PropertyChangeUpdateActionContributionItem((PropertyChangeUpdateAction)orderAction);
        if (items == null) {
            items = new IContributionItem[]{sortItem, orderItem};
        } else {
            IContributionItem[] combinedItems = new IContributionItem[items.length + 2];
            combinedItems[0] = sortItem;
            combinedItems[1] = orderItem;
            System.arraycopy(items, 0, combinedItems, 2, items.length);
            items = combinedItems;
        }
        return items;
    }

    public IContentProvider getContentProvider(TreeViewer viewer) {
        if (this.fContentProvider == null) {
            this.fContentProvider = new DTDTreeContentProvider();
        }
        return this.fContentProvider;
    }

    public ILabelProvider getLabelProvider(TreeViewer viewer) {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new DTDLabelProvider();
        }
        return this.fLabelProvider;
    }

    public IMenuListener getMenuListener(TreeViewer viewer) {
        this.fMenuHelper.createMenuListenersFor((Viewer)viewer);
        return this.fMenuHelper.getMenuListener();
    }

    protected IPreferenceStore getPreferenceStore() {
        return DTDUIPlugin.getDefault().getPreferenceStore();
    }

    public TransferDragSourceListener[] getTransferDragSourceListeners(TreeViewer treeViewer) {
        if (this.fTransferDragSourceListeners == null) {
            final ViewerDragAdapter dragAdapter = new ViewerDragAdapter((Viewer)treeViewer);
            this.fTransferDragSourceListeners = new TransferDragSourceListener[]{new TransferDragSourceListener(){

                public void dragFinished(DragSourceEvent event) {
                    dragAdapter.dragFinished(event);
                }

                public void dragSetData(DragSourceEvent event) {
                    dragAdapter.dragSetData(event);
                }

                public void dragStart(DragSourceEvent event) {
                    dragAdapter.dragStart(event);
                }

                public Transfer getTransfer() {
                    return ObjectTransfer.getInstance();
                }
            }};
        }
        return this.fTransferDragSourceListeners;
    }

    public TransferDropTargetListener[] getTransferDropTargetListeners(TreeViewer treeViewer) {
        if (this.fTransferDropTargetListeners == null) {
            final ViewerDropAdapter dropAdapter = new ViewerDropAdapter((Viewer)treeViewer, (DragAndDropManager)new DTDDragAndDropManager());
            this.fTransferDropTargetListeners = new TransferDropTargetListener[]{new TransferDropTargetListener(){

                public void dragEnter(DropTargetEvent event) {
                    dropAdapter.dragEnter(event);
                }

                public void dragLeave(DropTargetEvent event) {
                    dropAdapter.dragLeave(event);
                }

                public void dragOperationChanged(DropTargetEvent event) {
                    dropAdapter.dragOperationChanged(event);
                }

                public void dragOver(DropTargetEvent event) {
                    dropAdapter.dragOver(event);
                }

                public void drop(DropTargetEvent event) {
                    dropAdapter.drop(event);
                }

                public void dropAccept(DropTargetEvent event) {
                    dropAdapter.dropAccept(event);
                }

                public Transfer getTransfer() {
                    return ObjectTransfer.getInstance();
                }

                public boolean isEnabled(DropTargetEvent event) {
                    return this.getTransfer().isSupportedType(event.currentDataType);
                }
            }};
        }
        return this.fTransferDropTargetListeners;
    }

    public void setEditor(StructuredTextEditor editor) {
        super.setEditor(editor);
        this.fMenuHelper = new DTDContextMenuHelper(editor);
    }

    public void unconfigure(TreeViewer viewer) {
        super.unconfigure(viewer);
        this.fViewerContributions.remove(viewer);
        if (this.fMenuHelper != null) {
            this.fMenuHelper.removeMenuListenersFor((Viewer)viewer);
        }
    }
}

