/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.validation;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.dtd.ui.internal.validation.ValidateDTDAction;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class DTDValidator
implements IValidator {
    private final String GET_FILE = "getFile";
    public final String GET_PROJECT_FILES = "getAllFiles";

    static boolean shouldValidate(IFile file) {
        IFile resource = file;
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && resource.getName().charAt(0) != '.') continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0);
        return true;
    }

    public void cleanup(IReporter reporter) {
    }

    public void validate(IFile file) {
        ValidateDTDAction validateAction = new ValidateDTDAction(file, false);
        validateAction.setValidator(this);
        validateAction.run();
    }

    public void validate(IFile file, IReporter reporter, int ruleGroup) {
        ValidateDTDAction validateAction = new ValidateDTDAction(file, false);
        validateAction.setValidator(this);
        validateAction.run();
    }

    public void validate(IValidationContext context, IReporter reporter) throws ValidationException {
        String[] changedFiles = context.getURIs();
        if (changedFiles != null && changedFiles.length > 0) {
            int i = 0;
            while (i < changedFiles.length) {
                Object[] parms;
                IFile file;
                String changedFileName = changedFiles[i];
                if (changedFileName != null && (file = (IFile)context.loadModel("getFile", parms = new Object[]{changedFileName})) != null && DTDValidator.shouldValidate(file)) {
                    this.validateIfNeeded(file, context, reporter);
                }
                ++i;
            }
        } else {
            Object[] parms = new Object[]{this.getClass().getName()};
            Collection files = (Collection)context.loadModel("getAllFiles", parms);
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                IFile file = (IFile)iter.next();
                if (!DTDValidator.shouldValidate(file)) continue;
                this.validateIfNeeded(file, context, reporter);
            }
        }
    }

    protected void validateIfNeeded(IFile file, IValidationContext context, IReporter reporter) {
        Integer ruleGroupInt = (Integer)context.loadModel("PASS_LEVEL", null);
        int ruleGroup = ruleGroupInt == null ? 3 : ruleGroupInt;
        this.validate(file, reporter, ruleGroup);
    }
}

