/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lomboz.ws.axis.ui.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.objectweb.lomboz.ws.axis.core.Namespace;

public class NameSpaceDialog
extends InputDialog {
    private Text packageText;
    private Namespace namespace;

    public NameSpaceDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
        super(parentShell, "Namespace mapping", "Namespace", initialValue, validator);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        TextModifyListener modifyListener = new TextModifyListener();
        super.getText().addModifyListener((ModifyListener)modifyListener);
        Label packageLabel = new Label(composite, 0);
        packageLabel.setText("Package name");
        this.packageText = new Text(composite, 2048);
        this.packageText.setLayoutData((Object)new GridData(768));
        this.packageText.addModifyListener((ModifyListener)modifyListener);
        return composite;
    }

    private void validate() {
        String msg = this.validateNamespace();
        if (msg == null) {
            msg = this.validatePackage();
        }
        this.setErrorMessage(msg);
        if (msg == null) {
            this.namespace = new Namespace(this.getText().getText(), this.packageText.getText());
        }
    }

    private String validatePackage() {
        IStatus s = JavaConventions.validatePackageName((String)this.packageText.getText());
        return s.getSeverity() == 0 ? null : s.getMessage();
    }

    private String validateNamespace() {
        String ns = this.getText().getText();
        String message = null;
        if (ns == null || ns.length() < 1) {
            message = "Namespace can not be empty";
        }
        return message;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    private class TextModifyListener
    implements ModifyListener {
        TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            NameSpaceDialog.this.validate();
        }
    }
}

