/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lomboz.ws.axis.ui.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.objectweb.lomboz.ws.axis.core.AxisPreferenceStore;
import org.objectweb.lomboz.ws.axis.core.AxisRuntime;
import org.objectweb.lomboz.ws.axis.ui.DialogPanel;

public class AxisRuntimeWizardPage
extends WizardPage {
    DialogPanel panel;

    public AxisRuntimeWizardPage(String pageName) {
        super(pageName);
        this.setTitle("Axis Runtime Selection");
    }

    public AxisRuntimeWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.panel = new DialogPanel(parent, 0);
        int numOfCols = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = numOfCols;
        this.panel.setLayout((Layout)layout);
        this.panel.preferences = new Control[2];
        this.panel.fActive = new Button[2];
        this.panel.preferences[0] = this.panel.createLabeledCombo(0, false, true, "Version:", "Axis version", AxisPreferenceStore.getProperty("AXIS", "version"), new String[]{"1.0", "1.1", "1.2"}, this.panel);
        this.panel.preferences[1] = this.panel.createLabeledPath(1, true, "Axis Home:", "The path of the axis runtime installation", AxisPreferenceStore.getProperty("AXIS", "home"), this.panel);
        final Text axisPath = (Text)this.panel.preferences[1];
        axisPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AxisRuntime runtime = new AxisRuntime();
                runtime.setHome(axisPath.getText());
                IStatus[] result = runtime.validate();
                if (result.length > 0) {
                    AxisRuntimeWizardPage.this.setErrorMessage(result[0].getMessage());
                    AxisRuntimeWizardPage.this.setPageComplete(false);
                } else {
                    AxisRuntimeWizardPage.this.setMessage("", 1);
                    AxisRuntimeWizardPage.this.setPageComplete(true);
                }
            }
        });
        this.panel.update();
        this.setControl((Control)this.panel);
    }

    public boolean isPageComplete() {
        AxisRuntime runtime = new AxisRuntime();
        Text axisPath = (Text)this.panel.preferences[1];
        runtime.setHome(axisPath.getText());
        IStatus[] result = runtime.validate();
        return result.length == 0;
    }

    public void performOk() {
        String itemValue = "";
        itemValue = ((Text)this.panel.preferences[1]).getText();
        AxisPreferenceStore.setProperty("AXIS", "home", itemValue);
        Combo combo = (Combo)this.panel.preferences[0];
        itemValue = combo.getItem(combo.getSelectionIndex());
        AxisPreferenceStore.setProperty("AXIS", "version", itemValue);
    }
}

