/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lomboz.ws.axis.ui.action;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.objectweb.lomboz.ws.axis.core.AxisPlugin;
import org.objectweb.lomboz.ws.axis.core.Trace;

public abstract class AxisAction
extends ActionDelegate
implements IObjectActionDelegate {
    protected IStructuredSelection selection;
    protected Shell shell;
    public static final int PROGRESS_DIALOG = 1;
    public static final int PROGRESS_BUSYCURSOR = 2;
    static /* synthetic */ Class class$0;

    protected IProject[] getSelectedProjects() {
        ArrayList<Object> projects = null;
        if (!this.selection.isEmpty()) {
            projects = new ArrayList<Object>();
            Iterator elements = this.selection.iterator();
            while (elements.hasNext()) {
                Object adapter;
                Object next = elements.next();
                if (next instanceof IProject) {
                    projects.add(next);
                    continue;
                }
                if (!(next instanceof IAdaptable)) continue;
                IAdaptable a = (IAdaptable)next;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!((adapter = a.getAdapter((Class)clazz)) instanceof IProject)) continue;
                projects.add(adapter);
            }
        }
        if (projects != null && !projects.isEmpty()) {
            IProject[] result = new IProject[projects.size()];
            projects.toArray(result);
            return result;
        }
        return new IProject[0];
    }

    protected IResource[] getSelectedResources() {
        ArrayList<Object> resources = null;
        if (!this.selection.isEmpty()) {
            resources = new ArrayList<Object>();
            Iterator elements = this.selection.iterator();
            while (elements.hasNext()) {
                Object adapter;
                Object next = elements.next();
                if (next instanceof IResource) {
                    resources.add(next);
                    continue;
                }
                if (!(next instanceof IAdaptable)) continue;
                IAdaptable a = (IAdaptable)next;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!((adapter = a.getAdapter((Class)clazz)) instanceof IResource)) continue;
                resources.add(adapter);
            }
        }
        if (resources != null && !resources.isEmpty()) {
            IResource[] result = new IResource[resources.size()];
            resources.toArray(result);
            return result;
        }
        return new IResource[0];
    }

    private Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    protected Shell getShell() {
        if (this.shell != null) {
            return this.shell;
        }
        Display dsp = this.getDisplay();
        this.shell = dsp.getActiveShell();
        return this.shell;
    }

    protected final void run(final IRunnableWithProgress runnable, String problemMessage, int progressKind) {
        final Exception[] exceptions = new Exception[1];
        Display d = Display.findDisplay((Thread)Thread.currentThread());
        switch (progressKind) {
            case 2: {
                d.syncExec(new Runnable(){

                    public void run() {
                        try {
                            runnable.run((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (InvocationTargetException e) {
                            exceptions[0] = e;
                        }
                        catch (InterruptedException interruptedException) {
                            exceptions[0] = null;
                        }
                    }
                });
                break;
            }
            default: {
                try {
                    d.syncExec(new Runnable(){

                        public void run() {
                            try {
                                ProgressMonitorDialog pm = new ProgressMonitorDialog(AxisAction.this.getShell());
                                pm.run(false, true, runnable);
                            }
                            catch (InvocationTargetException e) {
                                exceptions[0] = e;
                            }
                            catch (InterruptedException interruptedException) {
                                exceptions[0] = null;
                            }
                        }
                    });
                    break;
                }
                catch (Exception e) {
                    exceptions[0] = e;
                }
            }
        }
        if (exceptions[0] != null) {
            this.handle(exceptions[0], null, problemMessage);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
            if (action != null) {
                try {
                    action.setEnabled(this.isEnabled());
                }
                catch (Exception e) {
                    action.setEnabled(false);
                    this.handle(e, null, null);
                }
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    protected void handle(Exception exception, String title, String message) {
        IStatus status = null;
        boolean log = false;
        boolean dialog = false;
        if (exception instanceof InvocationTargetException) {
            Throwable t = ((InvocationTargetException)exception).getTargetException();
            if (t instanceof CoreException) {
                status = ((CoreException)t).getStatus();
                log = true;
                dialog = true;
            } else {
                if (t instanceof InterruptedException) {
                    return;
                }
                status = new Status(4, AxisPlugin.getPLUGINID(), 1, "AxisAction.internal", t);
                log = true;
                dialog = true;
            }
        }
        if (status == null) {
            return;
        }
        if (!status.isOK()) {
            IStatus[] children;
            IStatus toShow = status;
            if (status.isMultiStatus() && (children = status.getChildren()).length == 1) {
                toShow = children[0];
            }
            if (title == null) {
                title = status.getMessage();
            }
            if (dialog) {
                ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)toShow);
            }
            if (log) {
                Trace.trace(toShow.getMessage());
            }
        }
    }

    protected abstract boolean isEnabled() throws Exception;

    public IStructuredSelection getSelection() {
        return this.selection;
    }
}

