/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.validation.core.errorinfo;

import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.wst.xml.core.internal.validation.core.logging.LoggerFactory;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;

public class ReferencedFileErrorUtility {
    static /* synthetic */ Class class$0;

    public static void openEditorAndGotoError(String uristring, final int line, final int column) {
        if (uristring != null) {
            try {
                URL uri = new URL(uristring);
                if (uri != null && "file".equals(uri.getProtocol())) {
                    IFile file;
                    String pathString = uri.getPath();
                    Path path = new Path(pathString);
                    String device = path.getDevice();
                    if (device != null && device.startsWith("/")) {
                        path = path.setDevice(device.substring(1));
                    }
                    if ((file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path)) != null && file.exists()) {
                        final IFile iFile = file;
                        IWorkbench workbench = XMLUIPlugin.getInstance().getWorkbench();
                        final IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                try {
                                    IEditorDescriptor descriptor = XMLUIPlugin.getInstance().getWorkbench().getEditorRegistry().getDefaultEditor(iFile.getName());
                                    String editorId = descriptor != null ? descriptor.getId() : XMLUIPlugin.getInstance().getWorkbench().getEditorRegistry().getDefaultEditor(String.valueOf(iFile.getName()) + ".txt").getId();
                                    workbenchWindow.getActivePage().openEditor((IEditorInput)new FileEditorInput(iFile), editorId);
                                }
                                catch (PartInitException ex) {
                                    LoggerFactory.getLoggerInstance().logError("Exception encountered when attempting to open file: " + iFile + "\n\n", (Throwable)ex);
                                }
                            }
                        });
                        Runnable runnable = new Runnable(){

                            public void run() {
                                IEditorPart editorPart = XMLUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                                ReferencedFileErrorUtility.gotoError(editorPart, line, column);
                            }
                        };
                        Display.getCurrent().asyncExec(runnable);
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    private static void gotoError(IEditorPart editorPart, int line, int column) {
        if (editorPart != null) {
            TextEditor textEditor;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.editors.text.TextEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((textEditor = (TextEditor)editorPart.getAdapter((Class)clazz)) != null) {
                try {
                    IDocumentProvider dp = textEditor.getDocumentProvider();
                    IDocument document = dp != null ? dp.getDocument((Object)textEditor.getEditorInput()) : null;
                    textEditor.selectAndReveal(document.getLineOffset(line - 1) + column - 1, 0);
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }
}

