/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.preferences;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.sse.core.internal.encoding.CommonCharsetNames;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.preferences.EncodingSettings;

public class WorkbenchDefaultEncodingSettings
extends Composite {
    private static final int INDENT = 15;
    private static final String WORKBENCH_DEFAULT = "";
    private EncodingSettings fEncodingSettings;
    private String fNonDefaultIANA = null;
    private Button fUseDefaultButton;

    public WorkbenchDefaultEncodingSettings(Composite parent) {
        super(parent, 0);
        this.createControls();
    }

    private void createControls() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.setLayoutData(data);
        Composite defaultEncodingComposite = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        data = new GridData(1808);
        defaultEncodingComposite.setLayout((Layout)layout);
        defaultEncodingComposite.setLayoutData((Object)data);
        this.fUseDefaultButton = new Button(defaultEncodingComposite, 32);
        this.fUseDefaultButton.setText(XMLUIMessages.WorkbenchDefaultEncodingSettings_0);
        this.fUseDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkbenchDefaultEncodingSettings.this.handleUseDefaultButtonSelected();
            }
        });
        this.fEncodingSettings = new EncodingSettings(this);
        ((GridLayout)this.fEncodingSettings.getLayout()).marginWidth = 0;
        ((GridData)this.fEncodingSettings.getLayoutData()).horizontalIndent = 15;
    }

    private Combo getEncodingCombo() {
        return this.fEncodingSettings.getEncodingCombo();
    }

    public String getIANATag() {
        if (!this.isDefault()) {
            return this.fEncodingSettings.getIANATag();
        }
        return WORKBENCH_DEFAULT;
    }

    private String getWorkbenchEncoding() {
        return ResourcesPlugin.getEncoding();
    }

    private void handleUseDefaultButtonSelected() {
        if (this.fUseDefaultButton.getSelection()) {
            this.fNonDefaultIANA = this.fEncodingSettings.getIANATag();
            String workbenchValue = this.getWorkbenchEncoding();
            workbenchValue = CommonCharsetNames.getIanaPreferredCharsetName((String)workbenchValue);
            this.fEncodingSettings.setIANATag(workbenchValue);
        } else if (this.fNonDefaultIANA != null) {
            this.fEncodingSettings.setIANATag(this.fNonDefaultIANA);
        }
        this.getEncodingCombo().setEnabled(!this.fUseDefaultButton.getSelection());
        this.fEncodingSettings.setEnabled(!this.fUseDefaultButton.getSelection());
    }

    private boolean isDefault() {
        return this.fUseDefaultButton.getSelection();
    }

    public void setIANATag(String ianaTag) {
        if (ianaTag == null || ianaTag.equals(WORKBENCH_DEFAULT)) {
            this.fUseDefaultButton.setSelection(true);
            this.handleUseDefaultButtonSelected();
        } else {
            this.fUseDefaultButton.setSelection(false);
            this.handleUseDefaultButtonSelected();
            if (!this.isDefault()) {
                this.fEncodingSettings.setIANATag(ianaTag);
            }
        }
    }
}

