/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.nsedit;

import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.nsedit.CommonEditNamespacesDialog;

public class CommonEditNamespacesTargetFieldDialog
extends CommonEditNamespacesDialog {
    protected String targetNamespace;
    protected Text targetNamespaceField;

    public CommonEditNamespacesTargetFieldDialog(Composite parent, IPath resourceLocation) {
        super(parent, resourceLocation, XMLUIMessages._UI_NAMESPACE_DECLARATIONS);
        Composite targetComp = this.getTopComposite();
        targetComp.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData(1808);
        Label targetNamespaceLabel = new Label(targetComp, 0);
        targetNamespaceLabel.setLayoutData((Object)gd);
        targetNamespaceLabel.setText(XMLUIMessages._UI_TARGET_NAMESPACE);
        this.targetNamespaceField = new Text(targetComp, 2048);
        this.targetNamespaceField.setLayoutData((Object)new GridData(768));
        this.targetNamespaceField.addModifyListener((ModifyListener)new TargetNamespaceModifyListener());
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void performEdit() {
        Object selection = this.getSelection(this.tableViewer.getSelection());
        if (selection != null) {
            boolean editTargetNamespace = false;
            NamespaceInfo nsInfo = (NamespaceInfo)selection;
            if (this.getTargetNamespace().equals(nsInfo.uri)) {
                editTargetNamespace = true;
            }
            this.invokeDialog(XMLUIMessages._UI_LABEL_NEW_NAMESPACE_INFORMATION, nsInfo);
            this.updateErrorMessage(this.namespaceInfoList);
            this.performDelayedUpdate();
            if (editTargetNamespace) {
                this.targetNamespaceField.setText(nsInfo.uri);
            }
        }
    }

    public void setTargetNamespace(String theTargetNamespace) {
        this.targetNamespace = theTargetNamespace != null ? theTargetNamespace : "";
        this.targetNamespaceField.setText(this.targetNamespace);
    }

    private void updateTargetNamespaceAndNamespaceInfo(String oldTargetNamespace, String newTargetNamespace) {
        NamespaceInfo info = this.getNamespaceInfo(newTargetNamespace);
        if (info == null) {
            info = this.getNamespaceInfo(oldTargetNamespace);
            if (info == null) {
                info = new NamespaceInfo(newTargetNamespace, "tns", null);
                this.namespaceInfoList.add(info);
            } else {
                info.uri = this.targetNamespace;
            }
        }
        this.tableViewer.refresh();
    }

    class TargetNamespaceModifyListener
    implements ModifyListener {
        TargetNamespaceModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String oldTargetNamespace = CommonEditNamespacesTargetFieldDialog.this.targetNamespace;
            CommonEditNamespacesTargetFieldDialog.this.targetNamespace = CommonEditNamespacesTargetFieldDialog.this.targetNamespaceField.getText();
            CommonEditNamespacesTargetFieldDialog.this.updateTargetNamespaceAndNamespaceInfo(oldTargetNamespace, CommonEditNamespacesTargetFieldDialog.this.targetNamespace);
        }
    }
}

