/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.filters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.common.navigator.internal.views.NavigatorMessages;
import org.eclipse.wst.common.navigator.internal.views.NavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.extensions.RegistryReader;
import org.eclipse.wst.common.navigator.internal.views.filters.ExtensionFilterProvider;

class ThirdPartyFilterProviderRegistry
extends RegistryReader {
    protected static final String THIRD_PARTY_FILTER_PROVIDER = "thirdPartyFilterProvider";
    protected static final String ATT_NAVIGATOR_EXTENSION_ID = "navigatorExtensionId";
    protected static final String ATT_CLASS = "class";
    protected static final String ATT_VIEWER_ID = "viewerId";
    private final Map thirdPartyFilterProviders = new HashMap();

    public ThirdPartyFilterProviderRegistry() {
        super(NavigatorPlugin.PLUGIN_ID, THIRD_PARTY_FILTER_PROVIDER);
        this.readRegistry();
    }

    public boolean readElement(IConfigurationElement element) {
        if (THIRD_PARTY_FILTER_PROVIDER.equals(element.getName())) {
            String navigatorExtensionId = element.getAttribute(ATT_NAVIGATOR_EXTENSION_ID);
            if (navigatorExtensionId != null) {
                this.addThirdPartyFilterProviders(new ThirdPartyFilterProviderDescriptor(navigatorExtensionId, element));
                return true;
            }
            NavigatorPlugin.log(NavigatorMessages.getString("ExtensionFilterRegistry.16"));
        }
        return false;
    }

    protected void addThirdPartyFilterProviders(ThirdPartyFilterProviderDescriptor descriptor) {
        this.getThirdPartyFilterProviders(descriptor.navigatorExtensionId).add(descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getThirdPartyFilterProviders(String navigatorExtensionId) {
        ArrayList result = (ArrayList)this.getThirdPartyFilterProviders().get(navigatorExtensionId);
        if (result != null) {
            return result;
        }
        Map map = this.getThirdPartyFilterProviders();
        synchronized (map) {
            result = (List)this.getThirdPartyFilterProviders().get(navigatorExtensionId);
            if (result == null) {
                result = new ArrayList();
                this.getThirdPartyFilterProviders().put(navigatorExtensionId, result);
            }
        }
        return result;
    }

    protected Map getThirdPartyFilterProviders() {
        return this.thirdPartyFilterProviders;
    }

    class ThirdPartyFilterProviderDescriptor {
        public final String navigatorExtensionId;
        public final String viewerId;
        public final IConfigurationElement element;
        protected ExtensionFilterProvider provider;

        public ThirdPartyFilterProviderDescriptor(String navigatorExtensionId, IConfigurationElement element) {
            this.navigatorExtensionId = navigatorExtensionId;
            this.element = element;
            this.viewerId = this.element.getAttribute(ThirdPartyFilterProviderRegistry.ATT_VIEWER_ID);
        }

        public ExtensionFilterProvider createProvider() {
            try {
                if (this.provider == null && this.element != null) {
                    this.provider = (ExtensionFilterProvider)this.element.createExecutableExtension(ThirdPartyFilterProviderRegistry.ATT_CLASS);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return this.provider;
        }
    }
}

