/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.filters;

import java.util.List;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonViewer;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorExtensionFilter;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorActivationService;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptor;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptorRegistry;
import org.eclipse.wst.common.navigator.internal.views.filters.ExtensionFilterDescriptor;
import org.eclipse.wst.common.navigator.internal.views.filters.ExtensionFilterRegistryManager;

public class CommonViewerFilter
extends ViewerFilter {
    private static final NavigatorActivationService NAVIGATOR_ACTIVATION_SERVICE = NavigatorActivationService.getInstance();
    private static final NavigatorContentDescriptorRegistry CONTENT_DESCRIPTOR_REGISTRY = NavigatorContentDescriptorRegistry.getInstance();
    private final CommonViewer commonViewer;
    private final NavigatorContentService contentService;

    public CommonViewerFilter(CommonViewer aViewer) {
        this.commonViewer = aViewer;
        this.contentService = aViewer.getNavigatorContentService();
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean select = true;
        List contentDescriptors = CONTENT_DESCRIPTOR_REGISTRY.getEnabledContentDescriptors(element);
        int extindex = 0;
        while (extindex < contentDescriptors.size() && select) {
            NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)contentDescriptors.get(extindex);
            if (NAVIGATOR_ACTIVATION_SERVICE.isNavigatorExtensionActive(this.contentService.getViewerId(), descriptor.getId())) {
                ExtensionFilterDescriptor[] enabledFilters = ExtensionFilterRegistryManager.getInstance().getViewerRegistry(this.contentService.getViewerId()).getActiveDescriptors(descriptor.getId());
                int filterindx = 0;
                while (filterindx < enabledFilters.length) {
                    INavigatorExtensionFilter filter = enabledFilters[filterindx].getInstance();
                    if (!filter.select(this.commonViewer, parentElement, element)) {
                        select = false;
                        break;
                    }
                    ++filterindx;
                }
            }
            ++extindex;
        }
        return select;
    }
}

