/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.extensions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.wst.common.navigator.internal.views.NavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorViewerDescriptor;
import org.eclipse.wst.common.navigator.internal.views.extensions.RegistryReader;

public class NavigatorViewerDescriptorRegistry
extends RegistryReader {
    private static final NavigatorViewerDescriptorRegistry INSTANCE = new NavigatorViewerDescriptorRegistry();
    protected static final String NAVIGATOR_VIEWER = "navigatorViewer";
    protected static final String ATT_VIEWER_ID = "viewerId";
    private static boolean isInitialized = false;
    private final Map viewerDescriptors = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NavigatorViewerDescriptorRegistry getInstance() {
        if (isInitialized) {
            return INSTANCE;
        }
        NavigatorViewerDescriptorRegistry navigatorViewerDescriptorRegistry = INSTANCE;
        synchronized (navigatorViewerDescriptorRegistry) {
            if (!isInitialized) {
                INSTANCE.readRegistry();
                isInitialized = true;
            }
        }
        return INSTANCE;
    }

    protected NavigatorViewerDescriptorRegistry() {
        super(NavigatorPlugin.PLUGIN_ID, NAVIGATOR_VIEWER);
    }

    public NavigatorViewerDescriptor getNavigatorViewerDescriptor(String viewerId) {
        return this.getOrCreateNavigatorViewerDescriptor(viewerId);
    }

    protected boolean readElement(IConfigurationElement element) {
        if (NAVIGATOR_VIEWER.equals(element.getName())) {
            try {
                String viewerId = element.getAttribute(ATT_VIEWER_ID);
                NavigatorViewerDescriptor descriptor = this.getOrCreateNavigatorViewerDescriptor(viewerId);
                descriptor.consume(element);
                return true;
            }
            catch (WorkbenchException e) {
                NavigatorPlugin.log("Unable to create navigator view descriptor.", e.getStatus());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NavigatorViewerDescriptor getOrCreateNavigatorViewerDescriptor(String aViewerId) {
        NavigatorViewerDescriptor viewerDescriptor = null;
        Map map = this.viewerDescriptors;
        synchronized (map) {
            viewerDescriptor = (NavigatorViewerDescriptor)this.viewerDescriptors.get(aViewerId);
            if (viewerDescriptor != null) {
                return viewerDescriptor;
            }
            viewerDescriptor = new NavigatorViewerDescriptor(aViewerId);
            this.viewerDescriptors.put(viewerDescriptor.getViewerId(), viewerDescriptor);
        }
        return viewerDescriptor;
    }
}

