/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.provisional.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonLabelProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentServiceContentProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentServiceLabelProvider;
import org.eclipse.wst.common.navigator.internal.views.extensions.IExtensionActivationListener;
import org.eclipse.wst.common.navigator.internal.views.extensions.INavigatorContentServiceListener;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorActivationService;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptor;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptorInstance;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptorRegistry;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorViewerDescriptor;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorViewerDescriptorRegistry;
import org.eclipse.wst.common.navigator.internal.views.extensions.StructuredViewerManager;

public class NavigatorContentService
implements IExtensionActivationListener {
    private static final NavigatorActivationService NAVIGATOR_ACTIVATION_SERVICE = NavigatorActivationService.getInstance();
    private static final NavigatorContentDescriptorRegistry CONTENT_DESCRIPTOR_REGISTRY = NavigatorContentDescriptorRegistry.getInstance();
    private static final NavigatorViewerDescriptorRegistry VIEWER_DESCRIPTOR_REGISTRY = NavigatorViewerDescriptorRegistry.getInstance();
    private static final NavigatorContentDescriptorInstance[] NO_DESCRIPTOR_INSTANCES = new NavigatorContentDescriptorInstance[0];
    private static final ITreeContentProvider[] NO_CONTENT_PROVIDERS = new ITreeContentProvider[0];
    private static final ILabelProvider[] NO_LABEL_PROVIDERS = new ILabelProvider[0];
    private final NavigatorViewerDescriptor viewerDescriptor;
    private final List listeners = new ArrayList();
    private final Map contentExtensions = new HashMap();
    private StructuredViewerManager structuredViewerManager;
    private ITreeContentProvider[] rootContentProviders;
    private Collection exclusions = new ArrayList();

    public NavigatorContentService(String aViewerId) {
        aViewerId = aViewerId != null ? aViewerId : "";
        this.viewerDescriptor = VIEWER_DESCRIPTOR_REGISTRY.getNavigatorViewerDescriptor(aViewerId);
        NavigatorActivationService.getInstance().addExtensionActivationListener(this.viewerDescriptor.getViewerId(), this);
    }

    public NavigatorContentService(String aViewerId, StructuredViewer aViewer) {
        this(aViewerId);
        this.structuredViewerManager = new StructuredViewerManager((Viewer)aViewer);
    }

    public ITreeContentProvider createCommonContentProvider() {
        return new NavigatorContentServiceContentProvider(this);
    }

    public ILabelProvider createCommonLabelProvider() {
        return new NavigatorContentServiceLabelProvider(this);
    }

    public void dispose() {
        Iterator contentItr = this.contentExtensions.values().iterator();
        while (contentItr.hasNext()) {
            ((NavigatorContentDescriptorInstance)contentItr.next()).dispose();
        }
        NavigatorActivationService.getInstance().removeExtensionActivationListener(this.viewerDescriptor.getViewerId(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateService(Viewer aViewer, Object anOldInput, Object aNewInput) {
        NavigatorContentService navigatorContentService = this;
        synchronized (navigatorContentService) {
            if (this.structuredViewerManager == null) {
                this.structuredViewerManager = new StructuredViewerManager(aViewer);
                this.structuredViewerManager.inputChanged(anOldInput, aNewInput);
            } else {
                this.structuredViewerManager.inputChanged(aViewer, anOldInput, aNewInput);
            }
            Iterator contentItr = this.contentExtensions.values().iterator();
            while (contentItr.hasNext()) {
                this.structuredViewerManager.initialize((IStructuredContentProvider)((NavigatorContentDescriptorInstance)contentItr.next()).getContentProvider());
            }
            NavigatorContentDescriptorInstance[] resultInstances = this.findRootContentDescriptors(aNewInput);
            this.rootContentProviders = this.extractContentProviders(resultInstances);
        }
    }

    public ITreeContentProvider[] findParentContentProviders(Object anElement) {
        NavigatorContentDescriptorInstance[] resultInstances = this.findRelevantContentDescriptorInstances(anElement);
        return this.extractContentProviders(resultInstances);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITreeContentProvider[] findRootContentProviders(Object anElement) {
        if (this.rootContentProviders != null) {
            return this.rootContentProviders;
        }
        NavigatorContentService navigatorContentService = this;
        synchronized (navigatorContentService) {
            if (this.rootContentProviders == null) {
                NavigatorContentDescriptorInstance[] resultInstances = this.findRootContentDescriptors(anElement);
                if (resultInstances.length > 0) {
                    this.rootContentProviders = this.extractContentProviders(resultInstances);
                } else {
                    resultInstances = this.findRootContentDescriptors(anElement, false);
                    this.rootContentProviders = this.extractContentProviders(resultInstances);
                }
            }
        }
        return this.rootContentProviders;
    }

    public ITreeContentProvider[] findRelevantContentProviders(Object anElement) {
        NavigatorContentDescriptorInstance[] resultInstances = this.findRelevantContentDescriptorInstances(anElement);
        return this.extractContentProviders(resultInstances);
    }

    public ILabelProvider[] findRelevantLabelProviders(Object anElement) {
        NavigatorContentDescriptorInstance[] resultInstances = this.findRelevantContentDescriptorInstances(anElement, false);
        return this.extractLabelProviders(resultInstances);
    }

    public NavigatorContentDescriptorInstance[] findRelevantContentDescriptorInstances(Object anElement) {
        List enabledDescriptors = this.getEnabledDescriptors(anElement);
        return this.extractDescriptorInstances(enabledDescriptors);
    }

    public NavigatorContentDescriptorInstance[] findRelevantContentDescriptorInstances(Object anElement, boolean toLoadIfNecessary) {
        List enabledDescriptors = this.getEnabledDescriptors(anElement);
        return this.extractDescriptorInstances(enabledDescriptors, toLoadIfNecessary);
    }

    public NavigatorContentDescriptorInstance[] findRelevantContentDescriptorInstances(IStructuredSelection aSelection) {
        List contentDescriptors = this.getEnabledDescriptors(aSelection);
        if (contentDescriptors.size() == 0) {
            return NO_DESCRIPTOR_INSTANCES;
        }
        NavigatorContentDescriptorInstance[] contentDescriptorInstances = new NavigatorContentDescriptorInstance[contentDescriptors.size()];
        int i = 0;
        while (i < contentDescriptors.size()) {
            NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)contentDescriptors.get(i);
            contentDescriptorInstances[i] = this.getDescriptorInstance(descriptor);
            ++i;
        }
        return contentDescriptorInstances;
    }

    private List getEnabledDescriptors(Object anElement) {
        return this.filterDescriptors(CONTENT_DESCRIPTOR_REGISTRY.getEnabledContentDescriptors(anElement, this.viewerDescriptor));
    }

    private List getEnabledDescriptors(IStructuredSelection aSelection) {
        return this.filterDescriptors(CONTENT_DESCRIPTOR_REGISTRY.getEnabledContentDescriptors(aSelection));
    }

    private List filterDescriptors(List contentDescriptors) {
        ArrayList<NavigatorContentDescriptor> result = new ArrayList<NavigatorContentDescriptor>();
        int x = 0;
        while (x < contentDescriptors.size()) {
            NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)contentDescriptors.get(x);
            if (!this.exclusions.contains(descriptor.getId())) {
                result.add(descriptor);
            }
            ++x;
        }
        return result;
    }

    public boolean initialize(IStructuredContentProvider aContentProvider) {
        return this.structuredViewerManager.initialize(aContentProvider);
    }

    public void onExtensionActivation(String aViewerId, String aNavigatorExtensionId, boolean toEnable) {
        this.update();
    }

    public void update() {
        this.rootContentProviders = null;
        this.structuredViewerManager.safeRefresh();
    }

    public final String getViewerId() {
        return this.viewerDescriptor.getViewerId();
    }

    public final NavigatorContentDescriptorInstance getDescriptorInstance(NavigatorContentDescriptor aDescriptorKey) {
        return this.getDescriptorInstance(aDescriptorKey, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final NavigatorContentDescriptorInstance getDescriptorInstance(NavigatorContentDescriptor aDescriptorKey, boolean toLoadIfNecessary) {
        NavigatorContentDescriptorInstance descriptorInstance = (NavigatorContentDescriptorInstance)this.contentExtensions.get(aDescriptorKey);
        if (descriptorInstance != null || !toLoadIfNecessary) {
            return descriptorInstance;
        }
        NavigatorContentService navigatorContentService = this;
        synchronized (navigatorContentService) {
            descriptorInstance = (NavigatorContentDescriptorInstance)this.contentExtensions.get(aDescriptorKey);
            if (descriptorInstance == null) {
                descriptorInstance = new NavigatorContentDescriptorInstance(aDescriptorKey, this, this.viewerDescriptor.getViewerId());
                this.contentExtensions.put(aDescriptorKey, descriptorInstance);
                this.notifyListeners(descriptorInstance);
            }
        }
        return descriptorInstance;
    }

    public NavigatorViewerDescriptor getViewerDescriptor() {
        return this.viewerDescriptor;
    }

    public void addExclusion(String anExtensionId) {
        this.exclusions.add(anExtensionId);
    }

    public void removeExclusion(String anExtensionId) {
        this.exclusions.remove(anExtensionId);
    }

    protected final NavigatorContentDescriptorInstance[] findRootContentDescriptors(Object anElement) {
        return this.findRootContentDescriptors(anElement, true);
    }

    protected final NavigatorContentDescriptorInstance[] findRootContentDescriptors(Object anElement, boolean toRespectViewerRoots) {
        String[] rootDescriptorIds = this.viewerDescriptor.getRootContentExtensionIds();
        NavigatorContentDescriptorInstance[] resultInstances = null;
        if (toRespectViewerRoots && rootDescriptorIds.length > 0 && rootDescriptorIds != NavigatorViewerDescriptor.DEFAULT_VIEWER_ID) {
            ArrayList<NavigatorContentDescriptorInstance> resultInstancesList = new ArrayList<NavigatorContentDescriptorInstance>();
            NavigatorContentDescriptor descriptor = null;
            NavigatorContentDescriptorInstance descriptorInstance = null;
            int i = 0;
            while (i < rootDescriptorIds.length) {
                if (this.isActive(rootDescriptorIds[i]) && !(descriptorInstance = this.getDescriptorInstance(descriptor = CONTENT_DESCRIPTOR_REGISTRY.getContentDescriptor(rootDescriptorIds[i]))).hasLoadingFailed()) {
                    resultInstancesList.add(descriptorInstance);
                }
                ++i;
            }
            resultInstances = new NavigatorContentDescriptorInstance[resultInstancesList.size()];
            resultInstancesList.toArray(resultInstances);
        } else {
            resultInstances = this.findRelevantContentDescriptorInstances(anElement);
        }
        return resultInstances;
    }

    protected boolean isActive(String anExtensionId) {
        return !this.exclusions.contains(anExtensionId) && NAVIGATOR_ACTIVATION_SERVICE.isNavigatorExtensionActive(this.getViewerId(), anExtensionId);
    }

    protected final Collection getDescriptorInstances() {
        return this.contentExtensions.size() > 0 ? Collections.unmodifiableCollection(this.contentExtensions.values()) : Collections.EMPTY_LIST;
    }

    public void addListener(INavigatorContentServiceListener aListener) {
        this.listeners.add(aListener);
    }

    public void removeListener(INavigatorContentServiceListener aListener) {
        this.listeners.remove(aListener);
    }

    private void notifyListeners(NavigatorContentDescriptorInstance aDescriptorInstance) {
        if (this.listeners.size() == 0) {
            return;
        }
        INavigatorContentServiceListener listener = null;
        ArrayList<INavigatorContentServiceListener> failedListeners = null;
        Iterator listenersItr = this.listeners.iterator();
        while (listenersItr.hasNext()) {
            try {
                listener = (INavigatorContentServiceListener)listenersItr.next();
                listener.onLoad(aDescriptorInstance);
            }
            catch (RuntimeException runtimeException) {
                if (failedListeners == null) {
                    failedListeners = new ArrayList<INavigatorContentServiceListener>();
                }
                failedListeners.add(listener);
            }
        }
        if (failedListeners != null) {
            this.listeners.removeAll(failedListeners);
        }
    }

    private ITreeContentProvider[] extractContentProviders(NavigatorContentDescriptorInstance[] theDescriptorInstances) {
        if (theDescriptorInstances.length == 0) {
            return NO_CONTENT_PROVIDERS;
        }
        ArrayList<ITreeContentProvider> resultProvidersList = new ArrayList<ITreeContentProvider>();
        int i = 0;
        while (i < theDescriptorInstances.length) {
            if (theDescriptorInstances[i].getContentProvider() != null) {
                resultProvidersList.add(theDescriptorInstances[i].getContentProvider());
            }
            ++i;
        }
        return resultProvidersList.toArray(new ITreeContentProvider[resultProvidersList.size()]);
    }

    private NavigatorContentDescriptorInstance[] extractDescriptorInstances(List theDescriptors) {
        return this.extractDescriptorInstances(theDescriptors, true);
    }

    private NavigatorContentDescriptorInstance[] extractDescriptorInstances(List theDescriptors, boolean toLoadAllIfNecessary) {
        if (theDescriptors.size() == 0) {
            return NO_DESCRIPTOR_INSTANCES;
        }
        ArrayList<NavigatorContentDescriptorInstance> resultInstances = new ArrayList<NavigatorContentDescriptorInstance>();
        int i = 0;
        while (i < theDescriptors.size()) {
            NavigatorContentDescriptorInstance descriptorInstance = this.getDescriptorInstance((NavigatorContentDescriptor)theDescriptors.get(i), toLoadAllIfNecessary);
            if (descriptorInstance != null) {
                resultInstances.add(descriptorInstance);
            }
            ++i;
        }
        return resultInstances.toArray(new NavigatorContentDescriptorInstance[resultInstances.size()]);
    }

    private ILabelProvider[] extractLabelProviders(NavigatorContentDescriptorInstance[] theDescriptorInstances) {
        if (theDescriptorInstances.length == 0) {
            return NO_LABEL_PROVIDERS;
        }
        ArrayList<ICommonLabelProvider> resultProvidersList = new ArrayList<ICommonLabelProvider>();
        int i = 0;
        while (i < theDescriptorInstances.length) {
            if (theDescriptorInstances[i].getLabelProvider() != null) {
                resultProvidersList.add(theDescriptorInstances[i].getLabelProvider());
            }
            ++i;
        }
        return resultProvidersList.toArray(new ILabelProvider[resultProvidersList.size()]);
    }
}

