/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.provisional.views;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.wst.common.navigator.internal.provisional.views.AdaptabilityUtility;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.NavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.ResourceToItemsMapper;
import org.eclipse.wst.common.navigator.internal.views.dnd.CommonNavigatorDragAdapter;
import org.eclipse.wst.common.navigator.internal.views.dnd.CommonNavigatorDropAdapter;

public class CommonViewer
extends TreeViewer {
    private final NavigatorContentService contentService;
    protected ResourceToItemsMapper fResourceToItemsMapper;
    static /* synthetic */ Class class$0;

    public CommonViewer(String aCommonNavigatorId, Composite aParent, int aStyle) {
        super(aParent, aStyle);
        this.contentService = new NavigatorContentService(aCommonNavigatorId, (StructuredViewer)this);
        this.init();
    }

    protected void init() {
        this.setUseHashlookup(true);
        this.setContentProvider((IContentProvider)this.contentService.createCommonContentProvider());
        DecoratingLabelProvider decoratingProvider = new DecoratingLabelProvider(this.contentService.createCommonLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        this.setLabelProvider((IBaseLabelProvider)decoratingProvider);
        this.initMapper();
        this.initDragAndDrop();
    }

    private void initMapper() {
        this.fResourceToItemsMapper = new ResourceToItemsMapper((ContentViewer)this);
    }

    public void dispose() {
        if (this.contentService != null) {
            this.contentService.dispose();
        }
    }

    public NavigatorContentService getNavigatorContentService() {
        return this.contentService;
    }

    protected void internalAdd(Widget widget, Object parentElement, Object[] childElements) {
        super.internalRefresh(widget, parentElement, true, true);
    }

    public void remove(Object[] elements) {
        super.remove(elements);
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.getContentProvider();
        int i = 0;
        while (i < elements.length) {
            super.internalRefresh(contentProvider.getParent(elements[i]));
            ++i;
        }
    }

    protected void removeWithoutRefresh(Object[] elements) {
        super.remove(elements);
    }

    protected void initDragAndDrop() {
        int operations = 3;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), PluginTransfer.getInstance(), FileTransfer.getInstance(), ResourceTransfer.getInstance()};
        this.addDragSupport(operations, transfers, (DragSourceListener)new CommonNavigatorDragAdapter(this));
        this.addDropSupport(operations, transfers, (DropTargetListener)new CommonNavigatorDropAdapter(this));
    }

    protected void createTreeItem(Widget parent, final Object element, int index) {
        try {
            super.createTreeItem(parent, element, index);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
        Job job = new Job("Extract the Content Descriptor of children"){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    CommonViewer.this.contentService.findRelevantContentProviders(element);
                }
                catch (RuntimeException ex) {
                    String msg = "Could not acquire children for Object: " + element.getClass();
                    NavigatorPlugin.log(msg, (IStatus)new Status(4, NavigatorPlugin.PLUGIN_ID, 0, msg, (Throwable)ex));
                }
                return Status.OK_STATUS;
            }
        };
        if (element instanceof ISchedulingRule) {
            job.setRule((ISchedulingRule)element);
        } else {
            ISchedulingRule rule;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.runtime.jobs.ISchedulingRule");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((rule = (ISchedulingRule)AdaptabilityUtility.getAdapter(element, clazz)) != null) {
                job.setRule(rule);
            }
        }
        job.schedule();
    }

    protected void mapElement(Object element, Widget item) {
        super.mapElement(element, item);
        if (item instanceof Item) {
            this.fResourceToItemsMapper.addToMap(element, (Item)item);
        }
    }

    protected void unmapElement(Object element, Widget item) {
        if (item instanceof Item) {
            this.fResourceToItemsMapper.removeFromMap(element, (Item)item);
        }
        super.unmapElement(element, item);
    }

    protected void unmapAllElements() {
        this.fResourceToItemsMapper.clearMap();
        super.unmapAllElements();
    }

    protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
        Object[] changed = event.getElements();
        if (changed != null && !this.fResourceToItemsMapper.isEmpty()) {
            ArrayList<Object> others = new ArrayList<Object>();
            int i = 0;
            while (i < changed.length) {
                Object curr = changed[i];
                if (curr instanceof IResource) {
                    this.fResourceToItemsMapper.resourceChanged((IResource)curr);
                } else {
                    others.add(curr);
                }
                ++i;
            }
            if (others.isEmpty()) {
                return;
            }
            event = new LabelProviderChangedEvent((IBaseLabelProvider)event.getSource(), others.toArray());
        }
        super.handleLabelProviderChanged(event);
    }

    protected void handleDispose(DisposeEvent event) {
        super.handleDispose(event);
        this.dispose();
    }
}

