/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.provisional.views;

import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonNavigator;
import org.eclipse.wst.common.navigator.internal.provisional.views.IDescriptionProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentServiceDescriptionProvider;

public class CommonNavigatorTitleProvider
extends LabelProvider {
    private CommonNavigator commonNavigator = null;
    private ILabelProvider labelProvider;
    private IDescriptionProvider descriptionProvider;

    public CommonNavigatorTitleProvider() {
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        Assert.isTrue((boolean)(part instanceof CommonNavigator));
        this.commonNavigator = (CommonNavigator)part;
        Assert.isTrue((boolean)(this.commonNavigator.getCommonViewer().getLabelProvider() instanceof ILabelProvider));
        this.labelProvider = (ILabelProvider)this.commonNavigator.getCommonViewer().getLabelProvider();
        this.descriptionProvider = new NavigatorContentServiceDescriptionProvider(this.commonNavigator.getNavigatorContentService());
    }

    protected IStructuredSelection getStructuredSelection(Object object) {
        if (object == null || !(object instanceof ISelection)) {
            return null;
        }
        ISelection aSelection = (ISelection)object;
        if (aSelection.isEmpty() || !(aSelection instanceof IStructuredSelection)) {
            return null;
        }
        return (IStructuredSelection)object;
    }

    public Image getImage(Object object) {
        IStructuredSelection structuredSelection = this.getStructuredSelection(object);
        if (structuredSelection == null || structuredSelection.size() > 1) {
            return null;
        }
        Object target = structuredSelection.getFirstElement();
        if (target == null) {
            return null;
        }
        if (this.labelProvider == null) {
            return null;
        }
        return this.labelProvider.getImage(target);
    }

    public String getText(Object object) {
        return this.descriptionProvider.getDescription(object);
    }
}

