/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.command;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class CopyToClipboardCommand
extends AbstractOverrideableCommand
implements AbstractCommand.NonDirtying {
    protected static final String LABEL = EMFEditPlugin.INSTANCE.getString("_UI_CopyToClipboardCommand_label");
    protected static final String DESCRIPTION = EMFEditPlugin.INSTANCE.getString("_UI_CopyToClipboardCommand_description");
    protected Collection sourceObjects;
    protected Collection oldClipboard;
    protected Command copyCommand;
    static /* synthetic */ Class class$0;

    public static Command create(EditingDomain domain, Collection collection) {
        if (domain == null) {
            CopyToClipboardCommand command = new CopyToClipboardCommand(domain, collection);
            return command;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.command.CopyToClipboardCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Command command = domain.createCommand(clazz, new CommandParameter(null, null, collection));
        return command;
    }

    public CopyToClipboardCommand(EditingDomain domain, Collection collection) {
        super(domain, LABEL, DESCRIPTION);
        this.sourceObjects = collection;
    }

    public static Command create(EditingDomain domain, Object owner) {
        return CopyToClipboardCommand.create(domain, Collections.singleton(owner));
    }

    public Collection getSourceObjects() {
        return this.sourceObjects;
    }

    protected boolean prepare() {
        this.copyCommand = CopyCommand.create(this.domain, this.sourceObjects);
        return this.copyCommand.canExecute();
    }

    public void doExecute() {
        this.copyCommand.execute();
        this.oldClipboard = this.domain.getClipboard();
        this.domain.setClipboard(this.copyCommand.getResult());
    }

    public void doUndo() {
        this.copyCommand.undo();
        this.domain.setClipboard(this.oldClipboard);
    }

    public void doRedo() {
        this.copyCommand.redo();
        this.oldClipboard = this.domain.getClipboard();
        this.domain.setClipboard(this.copyCommand.getResult());
    }

    public Collection doGetResult() {
        return this.copyCommand.getResult();
    }

    public Collection doGetAffectedObjects() {
        return this.copyCommand.getAffectedObjects();
    }

    public void doDispose() {
        if (this.copyCommand != null) {
            this.copyCommand.dispose();
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (domain: " + this.domain + ")");
        result.append(" (sourceObjects: " + this.sourceObjects + ")");
        result.append(" (oldClipboard: " + this.oldClipboard + ")");
        return result.toString();
    }
}

