/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.viewers;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.model.ModelAdapterListener;
import org.eclipse.wst.wsdl.ui.internal.util.ui.BaseDesignWindow;
import org.eclipse.wst.wsdl.ui.internal.util.ui.BorderPainter;
import org.eclipse.wst.wsdl.ui.internal.util.ui.FlatViewUtility;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseViewer
extends BaseDesignWindow
implements Listener,
SelectionListener {
    protected FlatViewUtility flatViewUtility = new FlatViewUtility(true);
    static Object oldInput = null;
    ModelAdapterListener oldModelAdapterListener = null;
    boolean listenerEnabled = true;
    protected DelayedEvent delayedTask;
    boolean isInDoHandle;

    public BaseViewer(IStatusLineManager statusLine) {
        super(statusLine);
    }

    public Object getInput() {
        return this.input;
    }

    public abstract void doSetInput(Object var1);

    public void setInput(Object input) {
        super.setInput(input);
        this.doSetInput(input);
    }

    public boolean isListenerEnabled() {
        return this.listenerEnabled;
    }

    public void setListenerEnabled(boolean v) {
        this.listenerEnabled = v;
    }

    public void handleEvent(Event event) {
        if (this.isListenerEnabled() && this.getInput() != null && !this.isInDoHandle) {
            this.isInDoHandle = true;
            this.startDelayedEvent(event);
            this.isInDoHandle = false;
        }
    }

    public abstract void doHandleEvent(Event var1);

    public abstract void createControl(Composite var1);

    protected void startDelayedEvent(Event e) {
        if (this.delayedTask == null || this.delayedTask.getEvent() == null) {
            this.delayedTask = new DelayedEvent();
            this.delayedTask.setEvent(e);
            Display.getDefault().timerExec(500, (Runnable)this.delayedTask);
        } else {
            Event delayedEvent = this.delayedTask.getEvent();
            if (e.widget == delayedEvent.widget && e.type == delayedEvent.type) {
                this.delayedTask.setEvent(null);
            }
            this.delayedTask = new DelayedEvent();
            this.delayedTask.setEvent(e);
            Display.getDefault().timerExec(500, (Runnable)this.delayedTask);
        }
    }

    public boolean isInDoHandle() {
        return this.isInDoHandle;
    }

    public Control getControl() {
        return this.mainUIComponent;
    }

    protected Control createDesignPane(Composite arg0, int arg1) {
        Control control = super.createDesignPane(arg0, arg1);
        Composite client = super.getControlsContainer();
        client.addPaintListener((PaintListener)new BorderPainter());
        client.setBackground(new Color((Device)Display.getCurrent(), 255, 255, 255));
        return control;
    }

    public ISelection getSelection() {
        return null;
    }

    public void refresh() {
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public Node getNode() {
        return (Node)this.getInput();
    }

    public void doWidgetDefaultSelected(SelectionEvent e) {
    }

    public void doWidgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (this.isListenerEnabled() && this.getInput() != null && !this.isInDoHandle) {
            this.isInDoHandle = true;
            this.doWidgetDefaultSelected(e);
            this.isInDoHandle = false;
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.isListenerEnabled() && this.getInput() != null && !this.isInDoHandle) {
            this.isInDoHandle = true;
            this.doWidgetSelected(e);
            this.isInDoHandle = false;
        }
    }

    public Node getChildNode(Element parent, String childName) {
        NodeList list = null;
        if (parent != null) {
            list = parent.getChildNodes();
        }
        if (list != null) {
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i) instanceof Element && list.item(i).getLocalName().equals(childName)) {
                    return list.item(i);
                }
                ++i;
            }
        }
        return null;
    }

    protected Element performAddElement(Node parentNode, String namespaceName, String localName) {
        if (parentNode != null) {
            Element newElement = this.createElement(parentNode, namespaceName, localName);
            parentNode.appendChild(newElement);
            this.format(parentNode);
            return newElement;
        }
        return null;
    }

    protected Element createElement(Node parentNode, String namespaceName, String localName) {
        Document document = parentNode.getOwnerDocument();
        Element element = document.createElement(localName);
        return element;
    }

    protected void addAttributes(Element newElement, String attr, String value) {
        newElement.setAttribute(attr, value);
    }

    protected void format(Node parentNode) {
        if (parentNode instanceof IDOMNode) {
            FormatProcessorXML formatProcessorXML = new FormatProcessorXML();
            formatProcessorXML.formatNode((Node)((IDOMNode)parentNode));
        }
    }

    protected static IEditorPart getActiveEditor() {
        IWorkbench workbench = WSDLEditorPlugin.getInstance().getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        IEditorPart editorPart = workbenchWindow.getActivePage().getActiveEditor();
        return editorPart;
    }

    protected static IStatusLineManager getStatusLineManager(IEditorPart editorPart) {
        IStatusLineManager result = null;
        try {
            EditorActionBarContributor contributor = (EditorActionBarContributor)editorPart.getEditorSite().getActionBarContributor();
            result = contributor.getActionBars().getStatusLineManager();
        }
        catch (Exception exception) {}
        return result;
    }

    class DelayedEvent
    implements Runnable {
        protected Event event;

        DelayedEvent() {
        }

        public void run() {
            if (this.event != null) {
                BaseViewer.this.isInDoHandle = true;
                BaseViewer.this.doHandleEvent(this.event);
                BaseViewer.this.isInDoHandle = false;
                this.event = null;
            }
        }

        public Event getEvent() {
            return this.event;
        }

        public void setEvent(Event event) {
            this.event = event;
        }
    }
}

