/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ExtensibleElement;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.model.ModelAdapter;
import org.eclipse.wst.wsdl.ui.internal.model.ModelAdapterFactory;
import org.eclipse.wst.wsdl.ui.internal.model.ModelAdapterListener;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;

public class WSDLGroupObject
implements ModelAdapter {
    public static final int IMPORTS_GROUP = 1;
    public static final int MESSAGES_GROUP = 2;
    public static final int SERVICES_GROUP = 3;
    public static final int PORT_TYPES_GROUP = 4;
    public static final int BINDINGS_GROUP = 5;
    public static final int TYPES_GROUP = 6;
    public static final int EXTENSIBILITY_ELEMENTS_GROUP = 7;
    protected Definition definition;
    protected int type;
    protected List listenerList = new ArrayList();
    protected ModelAdapterFactory modelAdapterFactory;

    public WSDLGroupObject(Definition definition, int type) {
        this(definition, type, null);
    }

    public WSDLGroupObject(Definition definition, int type, ModelAdapterFactory modelAdapterFactory) {
        this.definition = definition;
        this.type = type;
        this.modelAdapterFactory = modelAdapterFactory;
    }

    public Definition getParent() {
        return this.definition;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public int getType() {
        return this.type;
    }

    public String getLabel() {
        String name = "";
        switch (this.type) {
            case 1: {
                name = WSDLEditorPlugin.getWSDLString("_UI_FOLDER_IMPORTS");
                break;
            }
            case 2: {
                name = WSDLEditorPlugin.getWSDLString("_UI_FOLDER_MESSAGES");
                break;
            }
            case 3: {
                name = WSDLEditorPlugin.getWSDLString("_UI_FOLDER_SERVICES");
                break;
            }
            case 5: {
                name = WSDLEditorPlugin.getWSDLString("_UI_FOLDER_BINDINGS");
                break;
            }
            case 4: {
                name = WSDLEditorPlugin.getWSDLString("_UI_FOLDER_PORTTYPES");
                break;
            }
            case 6: {
                name = WSDLEditorPlugin.getWSDLString("_UI_FOLDER_TYPES");
                break;
            }
            case 7: {
                name = WSDLEditorPlugin.getWSDLString("_UI_FOLDER_EXTENSIBILITY_ELEMENTS");
            }
        }
        return name;
    }

    public Image getImage() {
        Image image = null;
        switch (this.type) {
            case 1: {
                image = WSDLEditorPlugin.getInstance().getImage("icons/importheader_obj.gif");
                break;
            }
            case 2: {
                image = WSDLEditorPlugin.getInstance().getImage("icons/messageheader_obj.gif");
                break;
            }
            case 3: {
                image = WSDLEditorPlugin.getInstance().getImage("icons/serviceheader_obj.gif");
                break;
            }
            case 4: {
                image = WSDLEditorPlugin.getInstance().getImage("icons/porttypeheader_obj.gif");
                break;
            }
            case 5: {
                image = WSDLEditorPlugin.getInstance().getImage("icons/bindingheader_obj.gif");
                break;
            }
            case 6: {
                image = WSDLEditorPlugin.getInstance().getImage("icons/types_obj.gif");
                break;
            }
            case 7: {
                image = WSDLEditorPlugin.getInstance().getImage("icons/fldr_el.gif");
            }
        }
        return image;
    }

    public void addListener(ModelAdapterListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public void removeListener(ModelAdapterListener listener) {
        this.listenerList.remove(listener);
    }

    public Object getProperty(Object modelObject, String propertyName) {
        Object result = null;
        if (propertyName.equals("CHILDREN_PROPERTY")) {
            result = this.getChildren();
        } else if (propertyName.equals("LABEL_PROPERTY")) {
            result = this.getLabel();
        } else if (propertyName.equals("IMAGE_PROPERTY")) {
            result = this.getImage();
        }
        return result;
    }

    public void firePropertyChanged(Object notifier, String property) {
        ArrayList list = new ArrayList();
        list.addAll(this.listenerList);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            ModelAdapterListener listener = (ModelAdapterListener)i.next();
            listener.propertyChanged(notifier, property);
        }
    }

    public List getChildren() {
        List list = Collections.EMPTY_LIST;
        ComponentReferenceUtil util = new ComponentReferenceUtil(this.definition);
        switch (this.getType()) {
            case 1: {
                list = this.definition.getEImports();
                break;
            }
            case 2: {
                try {
                    list = this.sortMessages(util.getMessages());
                }
                catch (Exception exception) {
                    list = util.getMessages();
                }
                break;
            }
            case 3: {
                list = util.getServices();
                break;
            }
            case 4: {
                list = util.getPortTypes();
                break;
            }
            case 5: {
                list = util.getBindings();
                break;
            }
            case 6: {
                Types types = this.definition.getETypes();
                if (types == null) break;
                list = (List)this.modelAdapterFactory.getAdapter(types).getProperty(types, "CHILDREN_PROPERTY");
                break;
            }
            case 7: {
                list = WSDLEditorUtil.getInstance().getExtensibilityElementNodes((ExtensibleElement)this.definition);
            }
        }
        return list;
    }

    private List initialSort(List inputList) {
        ArrayList<MessageGroup> messageGroups = new ArrayList<MessageGroup>();
        Iterator iterator = inputList.iterator();
        while (iterator.hasNext()) {
            Message newMessage = (Message)iterator.next();
            boolean messageAdded = false;
            int index = 0;
            while (index < messageGroups.size()) {
                MessageGroup messageItem = (MessageGroup)messageGroups.get(index);
                if (messageItem.addMessage(newMessage)) {
                    messageAdded = true;
                    break;
                }
                ++index;
            }
            if (messageAdded) continue;
            MessageGroup msGroup = new MessageGroup(newMessage.getQName().getLocalPart());
            msGroup.addMessage(newMessage);
            messageGroups.add(msGroup);
        }
        return messageGroups;
    }

    private List buildMessageList(List list) {
        ArrayList sortedMessageList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MessageGroup mGroup = (MessageGroup)iterator.next();
            sortedMessageList.addAll(mGroup.getMessages());
        }
        return sortedMessageList;
    }

    private List sortMessages(List inputList) {
        List sortedList = new ArrayList();
        sortedList.addAll(inputList);
        sortedList = this.initialSort(inputList);
        Collections.sort(sortedList, new Comparator(){

            public int compare(Object o1, Object o2) {
                String name1 = ((MessageGroup)o1).getBaseName();
                String name2 = ((MessageGroup)o2).getBaseName();
                return name1.compareToIgnoreCase(name2);
            }
        });
        sortedList = this.buildMessageList(sortedList);
        return sortedList;
    }

    private class MessageGroup {
        private String baseName;
        private Vector messages;

        public MessageGroup(String name) {
            this.baseName = this.computeBaseName(name);
            this.messages = new Vector();
        }

        public boolean addMessage(Message newMessage) {
            String newMessageBaseName = this.computeBaseName(newMessage.getQName().getLocalPart());
            if (newMessageBaseName.equalsIgnoreCase(this.getBaseName())) {
                this.addToSortedList(newMessage);
                return true;
            }
            return false;
        }

        public Vector getMessages() {
            return this.messages;
        }

        public String getBaseName() {
            return this.baseName;
        }

        private int getFirstInstance(String subString) {
            int index = 0;
            while (index < this.messages.size()) {
                Message message = (Message)this.messages.get(index);
                String messageName = message.getQName().getLocalPart();
                if (messageName.indexOf(subString, 1) > 0) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        private void addToSortedList(Message message) {
            int index = -1;
            String name = message.getQName().getLocalPart();
            if (name.indexOf("Request", 1) > 0) {
                index = this.getFirstInstance("Response");
            } else if (name.indexOf("Response", 1) > 0 && (index = this.getFirstInstance("Request")) >= 0) {
                ++index;
            }
            if (index >= 0) {
                this.messages.add(index, message);
            } else {
                this.messages.add(message);
            }
        }

        private String computeBaseName(String name) {
            int resReqLength;
            int resReqIndex = name.indexOf("Request", 1);
            if (resReqIndex == -1) {
                resReqIndex = name.indexOf("Response", 1);
                resReqLength = "Response".length();
            } else {
                resReqLength = "Request".length();
            }
            if (resReqIndex != -1) {
                return String.valueOf(name.substring(0, resReqIndex)) + name.substring(resReqIndex + resReqLength, name.length());
            }
            return name;
        }
    }
}

