/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.gef.util.figures;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class CenterLayout
extends AbstractLayout {
    public static final int ALIGNMENT_TOP = 1;
    public static final int ALIGNMENT_CENTER = 2;
    public static final int ALIGNMENT_BOTTOM = 3;
    protected int spacing;
    protected int verticalAlignment = 2;

    public CenterLayout() {
    }

    public CenterLayout(int spacing) {
        this.spacing = spacing;
    }

    protected Dimension calculatePreferredSize(IFigure figure, int width, int height) {
        Dimension d = this.calculatePreferredClientAreaSize(figure);
        d.expand(width, height);
        d.union(this.getBorderPreferredSize(figure));
        return d;
    }

    protected Dimension calculatePreferredClientAreaSize(IFigure figure) {
        Dimension d = new Dimension();
        List children = figure.getChildren();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            IFigure child = (IFigure)i.next();
            Dimension childSize = child.getPreferredSize();
            d.height += childSize.height;
            d.width = Math.max(childSize.width, d.width);
        }
        int childrenSize = children.size();
        if (childrenSize > 0) {
            d.height += this.spacing * children.size() - 1;
        }
        return d;
    }

    public Dimension getMinimumSize(IFigure figure, int width, int height) {
        Dimension d = new Dimension();
        List children = figure.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            d.union(child.getMinimumSize());
            ++i;
        }
        d.expand(figure.getInsets().getWidth(), figure.getInsets().getHeight());
        return d;
    }

    public Dimension getPreferredSize(IFigure figure, int width, int height) {
        return this.calculatePreferredSize(figure, figure.getInsets().getWidth(), figure.getInsets().getHeight());
    }

    public void layout(IFigure figure) {
        Rectangle r = figure.getClientArea();
        List children = figure.getChildren();
        Dimension preferredClientAreaSize = this.calculatePreferredClientAreaSize(figure);
        int x = r.x + (r.width - preferredClientAreaSize.width) / 2;
        int y = 0;
        switch (this.getVerticalAlignment()) {
            case 1: {
                y = r.y;
                break;
            }
            case 2: {
                y = r.y + (r.height - preferredClientAreaSize.height) / 2;
                break;
            }
            case 3: {
                y = r.y + (r.height - preferredClientAreaSize.height);
            }
        }
        Iterator i = children.iterator();
        while (i.hasNext()) {
            IFigure child = (IFigure)i.next();
            Dimension childSize = child.getPreferredSize();
            child.setBounds(new Rectangle(x, y, childSize.width, childSize.height));
            y += childSize.height + this.spacing;
        }
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    protected int getVerticalAlignment() {
        return this.verticalAlignment;
    }
}

