/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.contentgenerator;

import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.ui.internal.contentgenerator.ContentGenerator;
import org.w3c.dom.Element;

public class SoapContentGenerator
implements ContentGenerator {
    private final int DOCUMENT_LITERAL = 1;
    private final int RPC_LITERAL = 2;
    private final int RPC_ENCODED = 3;
    protected int bindingOption = 1;
    protected String namespaceValue = "";
    protected String addressLocation = "http://tempuri.org/";
    protected Definition definition;
    protected static final String[] requiredNamespaces = new String[]{"http://schemas.xmlsoap.org/wsdl/soap/"};
    protected static final String[] preferredNamespacePrefixes = new String[]{"soap"};

    public void init(Definition definition, Object generator, Object[] options) {
        this.definition = definition;
        if (options != null) {
            this.bindingOption = this.computeBindingOption(options);
            if (options.length > 1 && options[1] != null) {
                this.addressLocation = (String)options[1];
            }
        }
        if (definition.getTargetNamespace() != null) {
            this.namespaceValue = definition.getTargetNamespace();
        }
    }

    private int computeBindingOption(Object[] options) {
        int option = 1;
        if (options.length > 0 && options[0] != null) {
            boolean isDocumentLiteralOption = (Boolean)options[0];
            option = isDocumentLiteralOption ? 1 : 3;
            if (options.length >= 3 && options[2] != null && ((Boolean)options[2]).booleanValue()) {
                option = 2;
            }
        }
        return option;
    }

    public String[] getRequiredNamespaces() {
        return requiredNamespaces;
    }

    public String[] getPreferredNamespacePrefixes() {
        return preferredNamespacePrefixes;
    }

    public void generatePortContent(Element portElement, Port port) {
        Element element = this.createElement(portElement, "soap", "address");
        element.setAttribute("location", this.addressLocation);
    }

    public void generateBindingContent(Element bindingElement, PortType portType) {
        Element element = this.createElement(bindingElement, "soap", "binding");
        element.setAttribute("style", this.bindingOption == 1 ? "document" : "rpc");
        element.setAttribute("transport", "http://schemas.xmlsoap.org/soap/http");
    }

    public void generateBindingOperationContent(Element bindingOperationElement, Operation operation) {
        Element element = this.createElement(bindingOperationElement, "soap", "operation");
        String soapActionValue = this.namespaceValue;
        if (!soapActionValue.endsWith("/")) {
            soapActionValue = String.valueOf(soapActionValue) + "/";
        }
        soapActionValue = String.valueOf(soapActionValue) + operation.getName();
        element.setAttribute("soapAction", soapActionValue);
    }

    public void generateBindingInputContent(Element bindingInputElement, Input input) {
        this.generateSoapBody(bindingInputElement);
    }

    public void generateBindingOutputContent(Element bindingOutputElement, Output output) {
        this.generateSoapBody(bindingOutputElement);
    }

    public void generateBindingFaultContent(Element bindingFaultElement, Fault fault) {
        Element element = this.createElement(bindingFaultElement, "soap", "fault");
        element.setAttribute("name", fault.getName());
        element.setAttribute("use", this.bindingOption == 3 ? "encoded" : "literal");
        if (this.bindingOption == 3) {
            element.setAttribute("encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/");
            element.setAttribute("namespace", this.namespaceValue);
        } else if (this.bindingOption == 2) {
            element.setAttribute("namespace", this.namespaceValue);
        }
    }

    protected void generateSoapBody(Element parentElement) {
        if (this.definition.getTargetNamespace() != null) {
            this.definition.getTargetNamespace();
        }
        Element element = this.createElement(parentElement, "soap", "body");
        element.setAttribute("use", this.bindingOption == 3 ? "encoded" : "literal");
        if (this.bindingOption == 3) {
            element.setAttribute("encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/");
            element.setAttribute("namespace", this.namespaceValue);
        } else if (this.bindingOption == 2) {
            element.setAttribute("namespace", this.namespaceValue);
        }
    }

    protected Element createElement(Element parentElement, String prefix, String elementName) {
        String name = prefix != null ? String.valueOf(prefix) + ":" + elementName : elementName;
        Element result = parentElement.getOwnerDocument().createElement(name);
        parentElement.appendChild(result);
        return result;
    }
}

